/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.collection;

import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetDefaultToObject;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;
import org.apache.isis.core.progmodel.facets.collections.collection.JavaArrayFacet;
import org.apache.isis.core.progmodel.facets.collections.collection.JavaCollectionFacet;

public class CollectionFacetFactory
extends FacetFactoryAbstract
implements CollectionTypeRegistryAware,
AdapterMapAware {
    private CollectionTypeRegistry collectionTypeRegistry;
    private AdapterMap adapterMap;

    public CollectionFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        if (this.collectionTypeRegistry.isCollectionType(processClassContaxt.getCls())) {
            this.processCollectionType(processClassContaxt);
        } else if (this.collectionTypeRegistry.isArrayType(processClassContaxt.getCls())) {
            this.processAsArrayType(processClassContaxt);
        }
    }

    private void processCollectionType(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetHolder facetHolder = processClassContaxt.getFacetHolder();
        TypeOfFacet typeOfFacet = (TypeOfFacet)facetHolder.getFacet(TypeOfFacet.class);
        if (typeOfFacet == null) {
            Class<?> collectionElementType = this.collectionElementType(processClassContaxt.getCls());
            facetHolder.addFacet((Facet)(collectionElementType != Object.class ? new TypeOfFacetInferredFromGenerics(collectionElementType, facetHolder, this.getSpecificationLookup()) : new TypeOfFacetDefaultToObject(facetHolder, this.getSpecificationLookup())));
        }
        facetHolder.addFacet((Facet)new JavaCollectionFacet(facetHolder, this.getAdapterMap()));
    }

    private void processAsArrayType(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetHolder facetHolder = processClassContaxt.getFacetHolder();
        facetHolder.addFacet((Facet)new JavaArrayFacet(facetHolder, this.getAdapterMap()));
        facetHolder.addFacet((Facet)new TypeOfFacetInferredFromArray(processClassContaxt.getCls().getComponentType(), facetHolder, this.getSpecificationLookup()));
    }

    private Class<?> collectionElementType(Class<?> cls) {
        return Object.class;
    }

    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public AdapterMap getAdapterMap() {
        return this.adapterMap;
    }

    public void setAdapterMap(AdapterMap adapterManager) {
        this.adapterMap = adapterManager;
    }
}

