/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.clear;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacetAbstract;

public class CollectionClearFacetViaAccessor
extends CollectionClearFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final AdapterMap adapterMap;
    private final ObjectDirtier objectDirtier;

    public CollectionClearFacetViaAccessor(Method method, FacetHolder holder, AdapterMap adapterManager, ObjectDirtier objectDirtier) {
        super(holder);
        this.method = method;
        this.adapterMap = adapterManager;
        this.objectDirtier = objectDirtier;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    public void clear(ObjectAdapter owningAdapter) {
        Collection collection = (Collection)AdapterInvokeUtils.invoke((Method)this.method, (ObjectAdapter)owningAdapter);
        collection.clear();
        ObjectAdapter adapter = this.getAdapterMap().getAdapterFor((Object)owningAdapter);
        this.getObjectDirtier().objectChanged(adapter);
    }

    protected String toStringValues() {
        return "method=" + this.method;
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }
}

