/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.accessor;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.collections.accessor.CollectionAccessorFacetViaAccessor;

public class CollectionAccessorFacetFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"get"};

    public CollectionAccessorFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachAccessorFacetForAccessorMethod(processMethodContext);
    }

    private void attachAccessorFacetForAccessorMethod(FacetFactory.ProcessMethodContext processMethodContext) {
        Method accessorMethod = processMethodContext.getMethod();
        processMethodContext.removeMethod(accessorMethod);
        FacetHolder holder = processMethodContext.getFacetHolder();
        CollectionAccessorFacetViaAccessor facet = new CollectionAccessorFacetViaAccessor(accessorMethod, holder);
        FacetUtil.addFacet((Facet)facet);
    }

    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        return method.getName().startsWith("get");
    }

    public boolean isCollectionAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    public boolean isPropertyAccessor(Method method) {
        return false;
    }

    public boolean isValuePropertyAccessor(Method method) {
        return false;
    }

    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        Class[] collectionClasses;
        for (Class returnType : collectionClasses = this.getCollectionTypeRepository().getCollectionType()) {
            List list = methodRemover.removeMethods(MethodScope.OBJECT, "get", returnType, false, 0);
            methodListToAppendTo.addAll(list);
        }
    }

    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }
}

