/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.invoke;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.InvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacetAbstract;
import org.apache.isis.core.metamodel.facets.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.ReflectiveActionException;
import org.apache.log4j.Logger;

public class ActionInvocationFacetViaMethod
extends ActionInvocationFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = Logger.getLogger(ActionInvocationFacetViaMethod.class);
    private final Method method;
    private final int paramCount;
    private final ObjectSpecification onType;
    private final ObjectSpecification returnType;
    private final AdapterMap adapterMap;

    public ActionInvocationFacetViaMethod(Method method, ObjectSpecification onType, ObjectSpecification returnType, FacetHolder holder, AdapterMap adapterManager) {
        super(holder);
        this.method = method;
        this.paramCount = method.getParameterTypes().length;
        this.onType = onType;
        this.returnType = returnType;
        this.adapterMap = adapterManager;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public ObjectSpecification getReturnType() {
        return this.returnType;
    }

    public ObjectSpecification getOnType() {
        return this.onType;
    }

    public ObjectAdapter invoke(ObjectAdapter inObject, ObjectAdapter[] parameters) {
        if (parameters.length != this.paramCount) {
            LOG.error((Object)(this.method + " requires " + this.paramCount + " parameters, not " + parameters.length));
        }
        try {
            Object[] executionParameters = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                executionParameters[i] = ActionInvocationFacetViaMethod.unwrap(parameters[i]);
            }
            Object object = ActionInvocationFacetViaMethod.unwrap(inObject);
            Object result = this.method.invoke(object, executionParameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" action result " + result));
            }
            if (result == null) {
                return null;
            }
            ObjectAdapter resultAdapter = this.getAdapterMap().adapterFor(result);
            TypeOfFacet typeOfFacet = (TypeOfFacet)this.getFacetHolder().getFacet(TypeOfFacet.class);
            resultAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom((TypeOfFacet)typeOfFacet));
            return resultAdapter;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalStateException) {
                throw new ReflectiveActionException("IllegalStateException thrown while executing " + this.method + " " + e.getTargetException().getMessage(), e.getTargetException());
            }
            InvokeUtils.invocationException((String)("Exception executing " + this.method), (InvocationTargetException)e);
            return null;
        }
        catch (IllegalAccessException e) {
            throw new ReflectiveActionException("Illegal access of " + this.method, (Throwable)e);
        }
    }

    private static Object unwrap(ObjectAdapter adapter) {
        return adapter == null ? null : adapter.getObject();
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    protected String toStringValues() {
        return "method=" + this.method;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

