/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.invoke;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.actions.executed.ExecutedFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.actions.invoke.ActionInvocationFacetViaMethod;
import org.apache.isis.core.progmodel.facets.actions.invoke.DebugFacetViaNamingConvention;
import org.apache.isis.core.progmodel.facets.actions.invoke.ExecutedFacetViaNamingConvention;
import org.apache.isis.core.progmodel.facets.actions.invoke.ExplorationFacetViaNamingConvention;

public class ActionInvocationFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String EXPLORATION_PREFIX = "Exploration";
    private static final String DEBUG_PREFIX = "Debug";
    private static final String[] PREFIXES = new String[]{"Exploration", "Debug", "Remote", "Local"};
    private AdapterMap adapterMap;

    public ActionInvocationFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachInvocationFacet(processMethodContext);
        this.attachDebugFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachExplorationFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachExecutedFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachNamedFacetInferredFromMethodName(processMethodContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachInvocationFacet(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        try {
            Class<?> returnType = actionMethod.getReturnType();
            ObjectSpecification returnSpec = this.getSpecificationLookup().loadSpecification(returnType);
            if (returnSpec == null) {
                return;
            }
            Class cls = processMethodContext.getCls();
            ObjectSpecification typeSpec = this.getSpecificationLookup().loadSpecification(cls);
            FacetHolder holder = processMethodContext.getFacetHolder();
            FacetUtil.addFacet((Facet)new ActionInvocationFacetViaMethod(actionMethod, typeSpec, returnSpec, holder, this.getAdapterMap()));
        }
        finally {
            processMethodContext.removeMethod(actionMethod);
        }
    }

    private void attachExecutedFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        ExecutedFacet.Where where = ExecutedFacet.Where.lookup((Method)actionMethod);
        if (where == null) {
            return;
        }
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new ExecutedFacetViaNamingConvention(where, facetedMethod));
    }

    private void attachDebugFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        if (!capitalizedName.startsWith(DEBUG_PREFIX)) {
            return;
        }
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new DebugFacetViaNamingConvention(facetedMethod));
    }

    private void attachExplorationFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        if (!capitalizedName.startsWith(EXPLORATION_PREFIX)) {
            return;
        }
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new ExplorationFacetViaNamingConvention(facetedMethod));
    }

    private void attachNamedFacetInferredFromMethodName(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)method.getName());
        String name = StringUtils.removePrefix((String)capitalizedName, (String)"Local");
        name = StringUtils.removePrefix((String)name, (String)"Remote");
        name = StringUtils.removePrefix((String)name, (String)DEBUG_PREFIX);
        name = StringUtils.removePrefix((String)name, (String)EXPLORATION_PREFIX);
        name = StringUtils.removePrefix((String)name, (String)"Local");
        name = StringUtils.removePrefix((String)name, (String)"Remote");
        name = NameUtils.naturalName((String)name);
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new NamedFacetInferred(name, facetedMethod));
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

