/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.defaults.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.apache.isis.core.progmodel.facets.actions.invoke.ActionInvocationFacetViaMethod;

public class ActionDefaultsFacetViaMethod
extends ActionDefaultsFacetAbstract
implements ImperativeFacet {
    private final Method defaultMethod;
    private final Method actionMethod;

    public ActionDefaultsFacetViaMethod(Method defaultMethod, FacetHolder holder) {
        super(holder, false);
        this.defaultMethod = defaultMethod;
        this.actionMethod = ActionDefaultsFacetViaMethod.determineActionMethod(holder);
    }

    private static Method determineActionMethod(FacetHolder holder) {
        Method method2;
        Facet actionInvocationFacet = holder.getFacet(ActionInvocationFacet.class);
        if (actionInvocationFacet instanceof ActionInvocationFacetViaMethod) {
            ActionInvocationFacetViaMethod facetViaMethod = (ActionInvocationFacetViaMethod)actionInvocationFacet;
            method2 = facetViaMethod.getMethods().get(0);
        } else {
            method2 = null;
        }
        return method2;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.defaultMethod);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    public Object[] getDefaults(ObjectAdapter owningAdapter) {
        return (Object[])AdapterInvokeUtils.invoke((Method)this.defaultMethod, (ObjectAdapter)owningAdapter);
    }

    protected String toStringValues() {
        return "method=" + this.defaultMethod;
    }
}

