/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.defaults.method;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.actions.defaults.method.ActionDefaultsFacetViaMethod;

public class ActionDefaultsFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[]{"default"};
    private AdapterMap adapterMap;

    public ActionDefaultsFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        ActionDefaultsFacetFactory.attachActionDefaultsFacetIfParameterDefaultsMethodIsFound(processMethodContext);
    }

    private static void attachActionDefaultsFacetIfParameterDefaultsMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method defaultsMethod = ActionDefaultsFacetFactory.findDefaultsMethodReturning(processMethodContext, Object[].class);
        if (defaultsMethod == null) {
            defaultsMethod = ActionDefaultsFacetFactory.findDefaultsMethodReturning(processMethodContext, List.class);
        }
        if (defaultsMethod == null) {
            return;
        }
        processMethodContext.removeMethod(defaultsMethod);
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        ActionDefaultsFacetViaMethod facet = new ActionDefaultsFacetViaMethod(defaultsMethod, facetedMethod);
        FacetUtil.addFacet((Facet)facet);
    }

    private static Method findDefaultsMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, Class<?> returnType) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        String name = "default" + capitalizedName;
        Class cls = processMethodContext.getCls();
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, name, returnType, new Class[0]);
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

