/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;

public final class Util {
    private Util() {
    }

    public static String asStringUtf8(InputStream body) {
        try {
            return _Strings.ofBytes((byte[])_Bytes.of((InputStream)body), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not read body", new Object[0]);
        }
    }

    public static JsonRepresentation readAsMap(String body) {
        if (body == null) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        String bodyTrimmed = body.trim();
        if (bodyTrimmed.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        return Util.read(bodyTrimmed, "body");
    }

    public static JsonRepresentation readQueryStringAsMap(String queryString) {
        if (queryString == null) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        String queryStringTrimmed = queryString.trim();
        if (queryStringTrimmed.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        return Util.read(queryStringTrimmed, "query string");
    }

    public static JsonRepresentation readParameterMapAsMap(Map<String, String[]> parameterMap) {
        JsonRepresentation map = JsonRepresentation.newMap((String[])new String[0]);
        for (Map.Entry<String, String[]> parameter : parameterMap.entrySet()) {
            map.mapPut(parameter.getKey(), parameter.getValue()[0]);
        }
        return map;
    }

    private static JsonRepresentation read(String args, String argsNature) {
        try {
            JsonRepresentation jsonRepr = JsonMapper.instance().read(args);
            if (!jsonRepr.isMap()) {
                throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "could not read %s as a JSON map", argsNature);
            }
            return jsonRepr;
        }
        catch (JsonParseException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not parse %s", argsNature);
        }
        catch (JsonMappingException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not read %s as JSON", argsNature);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not parse %s", argsNature);
        }
    }
}

