/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.client.SuppressionType;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceForRestfulObjectsV1_0;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483637")
public class ContentNegotiationServiceOrgApacheIsisV1
extends ContentNegotiationServiceAbstract {
    public static final String ACCEPT_PROFILE = "urn:org.apache.isis/v1";
    public static final String CONTENT_TYPE_OAI_V1_OBJECT = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"object\"";
    public static final String CONTENT_TYPE_OAI_V1_OBJECT_COLLECTION = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"object-collection\"";
    public static final String CONTENT_TYPE_OAI_V1_LIST = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"list\"";
    private ContentNegotiationServiceForRestfulObjectsV1_0 restfulObjectsV1_0 = new ContentNegotiationServiceForRestfulObjectsV1_0();

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter) {
        JsonRepresentation $$roRepresentation;
        boolean canAccept = this.canAccept(rendererContext);
        if (!canAccept) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(rendererContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        this.appendObjectTo(rendererContext, objectAdapter, rootRepresentation, suppression);
        if (!suppressRO) {
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(rendererContext, objectAdapter, $$roRepresentation, rootRepresentation);
        responseBuilder.type(CONTENT_TYPE_OAI_V1_OBJECT);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndProperty objectAndProperty) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndCollection objectAndCollection) {
        JsonRepresentation $$roRepresentation;
        if (!this.canAccept(rendererContext)) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(rendererContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = JsonRepresentation.newArray();
        ObjectAdapter objectAdapter = objectAndCollection.getObjectAdapter();
        OneToManyAssociation collection = (OneToManyAssociation)objectAndCollection.getMember();
        this.appendCollectionTo(rendererContext, objectAdapter, collection, rootRepresentation, suppression);
        if (!suppressRO) {
            JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.arrayAdd($$roContainerRepresentation);
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(rendererContext, objectAndCollection, $$roRepresentation, rootRepresentation);
        responseBuilder.type(CONTENT_TYPE_OAI_V1_OBJECT_COLLECTION);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndAction objectAndAction) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndActionInvocation objectAndActionInvocation) {
        if (!this.canAccept(rendererContext)) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(rendererContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = null;
        JsonRepresentation $$roRepresentation = !suppressRO ? JsonRepresentation.newMap((String[])new String[0]) : null;
        ObjectAdapter returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        ObjectSpecification returnType = objectAndActionInvocation.getAction().getReturnType();
        if (returnedAdapter == null) {
            return null;
        }
        ActionResultRepresentation.ResultType resultType = objectAndActionInvocation.determineResultType();
        switch (resultType) {
            case DOMAIN_OBJECT: {
                rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                this.appendObjectTo(rendererContext, returnedAdapter, rootRepresentation, suppression);
                break;
            }
            case LIST: {
                rootRepresentation = JsonRepresentation.newArray();
                CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
                Stream collectionAdapters = CollectionFacet.Utils.streamAdapters((ManagedObject)returnedAdapter);
                this.appendStreamTo(rendererContext, collectionAdapters, rootRepresentation, suppression);
                if (suppressRO) break;
                JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                rootRepresentation.arrayAdd($$roContainerRepresentation);
                $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
                break;
            }
            case SCALAR_VALUE: 
            case VOID: {
                return null;
            }
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(rendererContext, objectAndActionInvocation, $$roRepresentation, rootRepresentation);
        responseBuilder.type(resultType == ActionResultRepresentation.ResultType.DOMAIN_OBJECT ? CONTENT_TYPE_OAI_V1_OBJECT : CONTENT_TYPE_OAI_V1_LIST);
        return this.responseBuilder(responseBuilder);
    }

    protected Response.ResponseBuilder responseBuilder(Response.ResponseBuilder responseBuilder) {
        return responseBuilder;
    }

    boolean canAccept(RepresentationService.Context rendererContext) {
        List<MediaType> acceptableMediaTypes = rendererContext.getAcceptableMediaTypes();
        return this.mediaTypeParameterMatches(acceptableMediaTypes, "profile", ACCEPT_PROFILE);
    }

    protected EnumSet<SuppressionType> suppress(RepresentationService.Context rendererContext) {
        List<MediaType> acceptableMediaTypes = rendererContext.getAcceptableMediaTypes();
        return SuppressionType.ParseUtil.parse(this.mediaTypeParameterList(acceptableMediaTypes, "suppress"));
    }

    private void appendObjectTo(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter, JsonRepresentation rootRepresentation, EnumSet<SuppressionType> suppression) {
        this.appendPropertiesTo(rendererContext, objectAdapter, rootRepresentation, suppression);
        Where where = rendererContext.getWhere();
        Stream collections = objectAdapter.getSpecification().streamCollections(Contributed.INCLUDED);
        collections.forEach(collection -> {
            JsonRepresentation collectionRepresentation = JsonRepresentation.newArray();
            rootRepresentation.mapPut(collection.getId(), collectionRepresentation);
            InteractionInitiatedBy interactionInitiatedBy = ContentNegotiationServiceOrgApacheIsisV1.determineInteractionInitiatedByFrom(rendererContext);
            Consent visibility = collection.isVisible((ManagedObject)objectAdapter, interactionInitiatedBy, where);
            if (!visibility.isAllowed()) {
                return;
            }
            this.appendCollectionTo(rendererContext, objectAdapter, (OneToManyAssociation)collection, collectionRepresentation, suppression);
        });
    }

    private void appendPropertiesTo(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter, JsonRepresentation rootRepresentation, EnumSet<SuppressionType> suppression) {
        InteractionInitiatedBy interactionInitiatedBy = ContentNegotiationServiceOrgApacheIsisV1.determineInteractionInitiatedByFrom(rendererContext);
        Where where = rendererContext.getWhere();
        Stream properties = objectAdapter.getSpecification().streamProperties(Contributed.INCLUDED);
        properties.forEach(property -> {
            String[] parts;
            String upHref;
            Consent visibility = property.isVisible((ManagedObject)objectAdapter, interactionInitiatedBy, where);
            if (!visibility.isAllowed()) {
                return;
            }
            JsonRepresentation propertyRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectPropertyReprRenderer renderer = (ObjectPropertyReprRenderer)new ObjectPropertyReprRenderer((RendererContext)rendererContext, null, property.getId(), propertyRepresentation).asStandalone();
            renderer.with(new ObjectAndProperty(objectAdapter, (OneToOneAssociation)property));
            JsonRepresentation propertyValueRepresentation = renderer.render();
            if (!suppression.contains(SuppressionType.HREF)) {
                upHref = propertyValueRepresentation.getString("links[rel=up].href");
                rootRepresentation.mapPut("$$href", upHref);
            }
            if (!suppression.contains(SuppressionType.TITLE)) {
                String upTitle = propertyValueRepresentation.getString("links[rel=up].title");
                rootRepresentation.mapPut("$$title", upTitle);
            }
            if (!suppression.contains(SuppressionType.DOMAIN_TYPE) && (parts = (upHref = propertyValueRepresentation.getString("links[rel=up].href")).split("[/]")).length > 2) {
                String upObjectType = parts[parts.length - 2];
                rootRepresentation.mapPut("$$domainType", upObjectType);
            }
            if (!suppression.contains(SuppressionType.ID) && (parts = (upHref = propertyValueRepresentation.getString("links[rel=up].href")).split("[/]")).length > 1) {
                String upInstanceId = parts[parts.length - 1];
                rootRepresentation.mapPut("$$instanceId", upInstanceId);
            }
            JsonRepresentation value = propertyValueRepresentation.getRepresentation("value", new Object[0]);
            rootRepresentation.mapPut(property.getId(), value);
        });
    }

    private void appendCollectionTo(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter, OneToManyAssociation collection, JsonRepresentation representation, EnumSet<SuppressionType> suppression) {
        InteractionInitiatedBy interactionInitiatedBy = ContentNegotiationServiceOrgApacheIsisV1.determineInteractionInitiatedByFrom(rendererContext);
        ObjectAdapter valueAdapter = collection.get(objectAdapter, interactionInitiatedBy);
        if (valueAdapter == null) {
            return;
        }
        Stream adapters = CollectionFacet.Utils.streamAdapters((ManagedObject)valueAdapter);
        this.appendStreamTo(rendererContext, adapters, representation, suppression);
    }

    private void appendStreamTo(RepresentationService.Context rendererContext, Stream<ObjectAdapter> adapters, JsonRepresentation collectionRepresentation, EnumSet<SuppressionType> suppression) {
        adapters.forEach(elementAdapter -> {
            JsonRepresentation elementRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            this.appendPropertiesTo(rendererContext, (ObjectAdapter)elementAdapter, elementRepresentation, suppression);
            collectionRepresentation.arrayAdd(elementRepresentation);
        });
    }

    private static InteractionInitiatedBy determineInteractionInitiatedByFrom(RendererContext rendererContext) {
        return rendererContext.getInteractionInitiatedBy();
    }
}

