/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.domain.DomainObjectList;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectActionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection2;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty2;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectCollectionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ContentNegotiationServiceForRestfulObjectsV1_0
implements ContentNegotiationService {
    private boolean strictAcceptChecking;

    @Override
    @PostConstruct
    public void init() {
        this.strictAcceptChecking = _Config.getConfiguration().getBoolean("isis.viewer.restfulobjects.strictAcceptChecking", false);
    }

    @Override
    @PreDestroy
    public void shutdown() {
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter) {
        List<MediaType> list = rendererContext.getAcceptableMediaTypes();
        this.ensureCompatibleAcceptHeader(RepresentationType.DOMAIN_OBJECT, list);
        Response.ResponseBuilder responseBuilder = this.buildResponseTo(rendererContext, objectAdapter, JsonRepresentation.newMap((String[])new String[0]), null);
        return this.responseBuilder(responseBuilder);
    }

    Response.ResponseBuilder buildResponseTo(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter, JsonRepresentation representationIfAnyRequired, JsonRepresentation rootRepresentation) {
        Version version;
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(rendererContext, null, representationIfAnyRequired);
        renderer.with(objectAdapter).includesSelf();
        Response.ResponseBuilder responseBuilder = Responses.ofOk(renderer, Caching.NONE, rootRepresentation);
        RepresentationService.Intent intent = rendererContext.getIntent();
        if (intent == RepresentationService.Intent.JUST_CREATED) {
            responseBuilder.status(Response.Status.CREATED);
        }
        if ((version = objectAdapter.getVersion()) != null && version.getTime() != null) {
            responseBuilder.tag(this.etagFormat().format(version.getTime()));
        }
        return responseBuilder;
    }

    private DateFormat etagFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndProperty objectAndProperty) {
        List<MediaType> list = rendererContext.getAcceptableMediaTypes();
        this.ensureCompatibleAcceptHeader(RepresentationType.OBJECT_PROPERTY, list);
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(rendererContext);
        ((ObjectPropertyReprRenderer)renderer.with(objectAndProperty)).usingLinkTo(rendererContext.getAdapterLinkTo());
        if (objectAndProperty instanceof ObjectAndProperty2) {
            ObjectAndProperty2 objectAndProperty2 = (ObjectAndProperty2)objectAndProperty;
            renderer.withMemberMode(objectAndProperty2.getMemberReprMode());
        }
        Response.ResponseBuilder responseBuilder = Responses.ofOk(renderer, Caching.NONE);
        return responseBuilder;
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndCollection objectAndCollection) {
        List<MediaType> list = rendererContext.getAcceptableMediaTypes();
        this.ensureCompatibleAcceptHeader(RepresentationType.OBJECT_COLLECTION, list);
        Response.ResponseBuilder responseBuilder = this.buildResponseTo(rendererContext, objectAndCollection, JsonRepresentation.newMap((String[])new String[0]), null);
        return this.responseBuilder(responseBuilder);
    }

    Response.ResponseBuilder buildResponseTo(RepresentationService.Context rendererContext, ObjectAndCollection objectAndCollection, JsonRepresentation representation, JsonRepresentation rootRepresentation) {
        ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer((RendererContext)rendererContext, null, null, representation);
        ((ObjectCollectionReprRenderer)renderer.with(objectAndCollection)).usingLinkTo(rendererContext.getAdapterLinkTo());
        if (objectAndCollection instanceof ObjectAndCollection2) {
            ObjectAndCollection2 objectAndCollection2 = (ObjectAndCollection2)objectAndCollection;
            renderer.withMemberMode(objectAndCollection2.getMemberReprMode());
        }
        return Responses.ofOk(renderer, Caching.NONE, rootRepresentation);
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndAction objectAndAction) {
        List<MediaType> list = rendererContext.getAcceptableMediaTypes();
        this.ensureCompatibleAcceptHeader(RepresentationType.OBJECT_ACTION, list);
        ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(rendererContext);
        ((ObjectActionReprRenderer)((ObjectActionReprRenderer)renderer.with(objectAndAction)).usingLinkTo(rendererContext.getAdapterLinkTo())).asStandalone();
        Response.ResponseBuilder responseBuilder = Responses.ofOk(renderer, Caching.NONE);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context rendererContext, ObjectAndActionInvocation objectAndActionInvocation) {
        Response.ResponseBuilder responseBuilder;
        List<MediaType> acceptableMediaTypes = rendererContext.getAcceptableMediaTypes();
        if (this.isAccepted(RepresentationType.DOMAIN_OBJECT, acceptableMediaTypes, true)) {
            ObjectAdapter adapter;
            Collection<ObjectAdapter> collectionAdapters = this.objectAdaptersFrom(objectAndActionInvocation);
            if (collectionAdapters != null) {
                ObjectSpecification elementSpec = this.elementSpecFrom(objectAndActionInvocation);
                String actionOwningType = ContentNegotiationServiceForRestfulObjectsV1_0.actionOwningTypeFrom(objectAndActionInvocation);
                String actionId = ContentNegotiationServiceForRestfulObjectsV1_0.actionIdFrom(objectAndActionInvocation);
                String actionArguments = ContentNegotiationServiceForRestfulObjectsV1_0.actionArgumentsFrom(objectAndActionInvocation);
                DomainObjectList list = ContentNegotiationServiceForRestfulObjectsV1_0.domainObjectListFrom(collectionAdapters, elementSpec, actionOwningType, actionId, actionArguments);
                adapter = rendererContext.getPersistenceSession().adapterFor((Object)list);
            } else {
                adapter = objectAndActionInvocation.getReturnedAdapter();
            }
            responseBuilder = this.buildResponse(rendererContext, adapter);
        } else if (this.isAccepted(RepresentationType.ACTION_RESULT, acceptableMediaTypes)) {
            responseBuilder = this.buildResponseTo(rendererContext, objectAndActionInvocation, JsonRepresentation.newMap((String[])new String[0]), null);
        } else {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE);
        }
        return this.responseBuilder(responseBuilder);
    }

    private static String actionOwningTypeFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        return objectAndActionInvocation.getAction().getOnType().getSpecId().asString();
    }

    private static String actionIdFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        return objectAndActionInvocation.getAction().getId();
    }

    private static String actionArgumentsFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        StringBuilder buf = new StringBuilder();
        List parameters = objectAndActionInvocation.getAction().getParameters();
        List<ObjectAdapter> argAdapters = objectAndActionInvocation.getArgAdapters();
        if (parameters.size() == argAdapters.size()) {
            for (int i = 0; i < parameters.size(); ++i) {
                ObjectActionParameter param = (ObjectActionParameter)parameters.get(i);
                ObjectAdapter argAdapter = argAdapters.get(i);
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(param.getName()).append("=");
                buf.append(ContentNegotiationServiceForRestfulObjectsV1_0.abbreviated(ContentNegotiationServiceForRestfulObjectsV1_0.titleOf(argAdapter), 8));
            }
        }
        return buf.toString();
    }

    private static String titleOf(ObjectAdapter argumentAdapter) {
        return argumentAdapter != null ? argumentAdapter.titleString(null) : "";
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    private static DomainObjectList domainObjectListFrom(Collection<ObjectAdapter> collectionAdapters, ObjectSpecification elementSpec, String actionOwningType, String actionId, String actionArguments) {
        String title = ContentNegotiationServiceForRestfulObjectsV1_0.titleFrom(collectionAdapters, elementSpec);
        DomainObjectList list = new DomainObjectList(title, elementSpec.getSpecId().asString(), actionOwningType, actionId, actionArguments);
        for (ObjectAdapter adapter : collectionAdapters) {
            list.getObjects().add(adapter.getPojo());
        }
        return list;
    }

    private static String titleFrom(Collection<ObjectAdapter> collectionAdapters, ObjectSpecification elementSpec) {
        String title;
        String singularName = elementSpec.getSingularName();
        String pluralName = elementSpec.getPluralName();
        int size = collectionAdapters.size();
        switch (size) {
            case 0: {
                title = "0 " + pluralName;
                break;
            }
            case 1: {
                title = "1 " + singularName;
                break;
            }
            default: {
                title = size + " " + pluralName;
            }
        }
        return title;
    }

    private ObjectSpecification elementSpecFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        TypeOfFacet typeOfFacet = (TypeOfFacet)objectAndActionInvocation.getAction().getFacet(TypeOfFacet.class);
        return typeOfFacet != null ? typeOfFacet.valueSpec() : this.getSpecificationLoader().loadSpecification(Object.class);
    }

    private Collection<ObjectAdapter> objectAdaptersFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        ObjectAdapter returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        ObjectSpecification returnType = objectAndActionInvocation.getAction().getReturnType();
        CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
        return collectionFacet != null ? (Collection)collectionFacet.stream((ManagedObject)returnedAdapter).collect(Collectors.toList()) : null;
    }

    Response.ResponseBuilder buildResponseTo(RepresentationService.Context rendererContext, ObjectAndActionInvocation objectAndActionInvocation, JsonRepresentation representation, JsonRepresentation rootRepresentation) {
        ActionResultReprRenderer renderer = new ActionResultReprRenderer((RendererContext)rendererContext, null, objectAndActionInvocation.getSelfLink(), representation);
        renderer.with(objectAndActionInvocation).using(rendererContext.getAdapterLinkTo());
        Response.ResponseBuilder responseBuilder = Responses.ofOk(renderer, Caching.NONE, rootRepresentation);
        Responses.addLastModifiedAndETagIfAvailable(responseBuilder, objectAndActionInvocation.getObjectAdapter().getVersion());
        return responseBuilder;
    }

    protected Response.ResponseBuilder responseBuilder(Response.ResponseBuilder responseBuilder) {
        return responseBuilder;
    }

    private void ensureCompatibleAcceptHeader(RepresentationType representationType, List<MediaType> acceptableMediaTypes) {
        if (!this.strictAcceptChecking) {
            return;
        }
        if (representationType == null) {
            return;
        }
        String producedProfile = representationType.getMediaTypeProfile();
        if (producedProfile == null) {
            return;
        }
        boolean accepted = ContentNegotiationServiceForRestfulObjectsV1_0.isAccepted(producedProfile, acceptableMediaTypes);
        if (!accepted) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE);
        }
    }

    private boolean isAccepted(RepresentationType representationType, List<MediaType> acceptableMediaTypes) {
        return this.isAccepted(representationType, acceptableMediaTypes, this.strictAcceptChecking);
    }

    private boolean isAccepted(RepresentationType representationType, List<MediaType> acceptableMediaTypes, boolean strictAcceptChecking) {
        if (!strictAcceptChecking) {
            return true;
        }
        String producedProfile = representationType.getMediaTypeProfile();
        if (producedProfile == null) {
            throw new IllegalArgumentException("RepresentationType " + representationType + " does not specify a 'profile' parameter");
        }
        return ContentNegotiationServiceForRestfulObjectsV1_0.isAccepted(producedProfile, acceptableMediaTypes);
    }

    private static boolean isAccepted(String producedProfile, List<MediaType> acceptableMediaTypes) {
        for (MediaType mediaType : acceptableMediaTypes) {
            String acceptedProfileValue = (String)mediaType.getParameters().get("profile");
            if (acceptedProfileValue == null || producedProfile.equals(acceptedProfileValue)) continue;
            return false;
        }
        return true;
    }

    private SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

