/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.node.NullNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class JsonValueEncoder {
    private static Map<ObjectSpecId, JsonValueConverter> converterBySpec = _Maps.newLinkedHashMap();
    private static ObjectAdapterProvider testAdapterManager;

    private JsonValueEncoder() {
    }

    private static void putConverter(JsonValueConverter jvc) {
        List<ObjectSpecId> specIds = jvc.getSpecIds();
        for (ObjectSpecId specId : specIds) {
            converterBySpec.put(specId, jvc);
        }
    }

    public static ObjectAdapter asAdapter(ObjectSpecification objectSpec, JsonRepresentation argValueRepr, String format) {
        if (argValueRepr == null) {
            return null;
        }
        if (objectSpec == null) {
            throw new IllegalArgumentException("ObjectSpecification is required");
        }
        if (!argValueRepr.isValue()) {
            throw new IllegalArgumentException("Representation must be of a value");
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            String reason = "ObjectSpec expected to have an EncodableFacet";
            throw new IllegalArgumentException(reason);
        }
        ObjectSpecId specId = objectSpec.getSpecId();
        JsonValueConverter jvc = converterBySpec.get(specId);
        if (jvc == null) {
            if (argValueRepr.isString()) {
                String argStr = argValueRepr.asString();
                return encodableFacet.fromEncodedString(argStr);
            }
            throw new IllegalArgumentException("Unable to parse value");
        }
        ObjectAdapter asAdapter = jvc.asAdapter(argValueRepr, format);
        if (asAdapter != null) {
            return asAdapter;
        }
        if (argValueRepr.isString()) {
            String argStr = argValueRepr.asString();
            try {
                return encodableFacet.fromEncodedString(argStr);
            }
            catch (TextEntryParseException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        throw new IllegalArgumentException("Could not parse value '" + argValueRepr.asString() + "' as a " + objectSpec.getFullIdentifier());
    }

    public static Object appendValueAndFormat(ObjectSpecification objectSpec, ObjectAdapter objectAdapter, JsonRepresentation repr, String format, boolean suppressExtensions) {
        JsonValueConverter jvc = converterBySpec.get(objectSpec.getSpecId());
        if (jvc != null) {
            return jvc.appendValueAndFormat(objectAdapter, format, repr, suppressExtensions);
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            throw new IllegalArgumentException("objectSpec expected to have EncodableFacet");
        }
        NullNode value = objectAdapter != null ? encodableFacet.toEncodedString(objectAdapter) : NullNode.getInstance();
        repr.mapPut("value", (Object)value);
        JsonValueEncoder.appendFormats(repr, "string", "string", suppressExtensions);
        return value;
    }

    public static Object asObject(ObjectAdapter objectAdapter, String format) {
        if (objectAdapter == null) {
            throw new IllegalArgumentException("objectAdapter cannot be null");
        }
        ObjectSpecification objectSpec = objectAdapter.getSpecification();
        JsonValueConverter jvc = converterBySpec.get(objectSpec.getSpecId());
        if (jvc != null) {
            return jvc.asObject(objectAdapter, format);
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            throw new IllegalArgumentException("objectSpec expected to have EncodableFacet");
        }
        return encodableFacet.toEncodedString(objectAdapter);
    }

    private static void appendFormats(JsonRepresentation repr, String format, String xIsisFormat, boolean suppressExtensions) {
        if (format != null) {
            repr.mapPut("format", format);
        }
        if (!suppressExtensions && xIsisFormat != null) {
            repr.mapPut("extensions.x-isis-format", xIsisFormat);
        }
    }

    private static Object unwrapAsObjectElseNullNode(ObjectAdapter objectAdapter) {
        return objectAdapter != null ? objectAdapter.getPojo() : NullNode.getInstance();
    }

    private static ObjectAdapter adapterFor(Object value) {
        return JsonValueEncoder.getObjectAdapterProvider().adapterFor(value);
    }

    static void testSetAdapterManager(ObjectAdapterProvider adapterManager) {
        testAdapterManager = adapterManager;
    }

    public static ObjectAdapterProvider getObjectAdapterProvider() {
        return testAdapterManager != null ? testAdapterManager : JsonValueEncoder.getPersistenceSession();
    }

    private static PersistenceSession getPersistenceSession() {
        return JsonValueEncoder.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    static IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    static {
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "string", new Class[]{String.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    return JsonValueEncoder.adapterFor(repr.asString());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof String) {
                    String str = (String)obj;
                    repr.mapPut("value", str);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "boolean", new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isBoolean()) {
                    return JsonValueEncoder.adapterFor(repr.asBoolean());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    repr.mapPut("value", b);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "byte", new Class[]{Byte.TYPE, Byte.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().byteValue());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor((byte)repr.asInt().intValue());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor((byte)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().byteValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Byte) {
                    Byte b = (Byte)obj;
                    repr.mapPut("value", b);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "short", new Class[]{Short.TYPE, Short.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().shortValue());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor((short)repr.asInt().intValue());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor((short)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().shortValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Short) {
                    Short s = (Short)obj;
                    repr.mapPut("value", s);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "int", new Class[]{Integer.TYPE, Integer.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(repr.asInt());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor((int)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().intValue());
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().intValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    repr.mapPut("value", i);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "long", new Class[]{Long.TYPE, Long.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(repr.asLong());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(repr.asLong());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().longValue());
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().longValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Long) {
                    Long l = (Long)obj;
                    repr.mapPut("value", l);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("decimal", "float", new Class[]{Float.TYPE, Float.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isDouble()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf((float)repr.asDouble().doubleValue()));
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asNumber().floatValue()));
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asLong().longValue()));
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asInt().intValue()));
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asBigInteger().floatValue()));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Float) {
                    Float f = (Float)obj;
                    repr.mapPut("value", f);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("decimal", "double", new Class[]{Double.TYPE, Double.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isDouble()) {
                    return JsonValueEncoder.adapterFor(repr.asDouble());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(repr.asLong());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(repr.asInt());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().doubleValue());
                }
                if (repr.isBigDecimal()) {
                    return JsonValueEncoder.adapterFor(repr.asBigDecimal().doubleValue());
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().doubleValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Double) {
                    Double d = (Double)obj;
                    repr.mapPut("value", d);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "char", new Class[]{Character.TYPE, Character.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                Integer x;
                String str;
                if (repr.isString() && (str = repr.asString()) != null && str.length() > 0) {
                    return JsonValueEncoder.adapterFor(Character.valueOf(str.charAt(0)));
                }
                if (repr.isInt() && 0 <= (x = repr.asInt()) && x <= 65535) {
                    char c = (char)x.intValue();
                    return JsonValueEncoder.adapterFor(Character.valueOf(c));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Character) {
                    Character c = (Character)obj;
                    repr.mapPut("value", c);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("big-integer(18)", "javamathbiginteger", new Class[]{BigInteger.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    return JsonValueEncoder.adapterFor(new BigInteger(repr.asString()));
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger(format));
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(BigInteger.valueOf(repr.asLong()));
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(BigInteger.valueOf(repr.asInt().intValue()));
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(BigInteger.valueOf(repr.asNumber().longValue()));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof BigInteger) {
                    BigInteger bi = (BigInteger)obj;
                    repr.mapPut("value", bi);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, format != null ? format : this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("big-decimal", "javamathbigdecimal", new Class[]{BigDecimal.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    return JsonValueEncoder.adapterFor(new BigDecimal(repr.asString()));
                }
                if (repr.isBigDecimal()) {
                    return JsonValueEncoder.adapterFor(repr.asBigDecimal(format));
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(new BigDecimal(repr.asBigInteger()));
                }
                if (repr.isDouble()) {
                    return JsonValueEncoder.adapterFor(BigDecimal.valueOf(repr.asDouble()));
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(BigDecimal.valueOf(repr.asLong()));
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(BigDecimal.valueOf(repr.asInt().intValue()));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)obj;
                    repr.mapPut("value", bd);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, format != null ? format : this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date", "jodalocaldate", new Class[]{LocalDate.class}){
            final List<DateTimeFormatter> formatters = Arrays.asList(ISODateTimeFormat.date(), ISODateTimeFormat.basicDate(), DateTimeFormat.forPattern((String)"yyyyMMdd"), JsonRepresentation.yyyyMMdd);

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            LocalDate parsedDate = formatter.parseLocalDate(dateStr);
                            return JsonValueEncoder.adapterFor(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof LocalDate) {
                    LocalDate date = (LocalDate)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTimeAtStartOfDay());
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date-time", "jodalocaldatetime", new Class[]{LocalDateTime.class}){
            final List<DateTimeFormatter> formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            LocalDateTime parsedDate = formatter.parseLocalDateTime(dateStr);
                            return JsonValueEncoder.adapterFor(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof LocalDateTime) {
                    LocalDateTime date = (LocalDateTime)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTime());
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date-time", "jodadatetime", new Class[]{DateTime.class}){
            final List<DateTimeFormatter> formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parsedDate = formatter.parseDateTime(dateStr);
                            return JsonValueEncoder.adapterFor(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof DateTime) {
                    DateTime date = (DateTime)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTime());
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date-time", "javautildate", new Class[]{java.util.Date.class}){
            final List<DateTimeFormatter> formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            java.util.Date parsedDate = parseDateTime.toDate();
                            return JsonValueEncoder.adapterFor(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)obj;
                    DateTimeFormatter dateTimeFormatter = this.formatters.get(0);
                    String dateStr = dateTimeFormatter.print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date", "javasqldate", new Class[]{Date.class}){
            final List<DateTimeFormatter> formatters = Arrays.asList(ISODateTimeFormat.date().withZoneUTC(), ISODateTimeFormat.basicDate().withZoneUTC(), JsonRepresentation.yyyyMMdd.withZoneUTC());

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            Date parsedDate = new Date(parseDateTime.getMillis());
                            return JsonValueEncoder.adapterFor(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Date) {
                    Date date = (Date)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("time", "javasqltime", new Class[]{Time.class}){
            final List<DateTimeFormatter> formatters = Arrays.asList(ISODateTimeFormat.hourMinuteSecond().withZoneUTC(), ISODateTimeFormat.basicTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicTime().withZoneUTC(), JsonRepresentation._HHmmss.withZoneUTC());

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            Time parsedTime = new Time(parseDateTime.getMillis());
                            return JsonValueEncoder.adapterFor(parsedTime);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Time) {
                    Time date = (Time)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("utc-millisec", "javasqltimestamp", new Class[]{Timestamp.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr, String format) {
                if (repr.isLong()) {
                    Long millis = repr.asLong();
                    Timestamp parsedTimestamp = new Timestamp(millis);
                    return JsonValueEncoder.adapterFor(parsedTimestamp);
                }
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    try {
                        Long parseMillis = Long.parseLong(dateStr);
                        Timestamp parsedTimestamp = new Timestamp(parseMillis);
                        return JsonValueEncoder.adapterFor(parsedTimestamp);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Timestamp) {
                    Timestamp date = (Timestamp)obj;
                    long millisStr = date.getTime();
                    repr.mapPut("value", millisStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
    }

    public static abstract class JsonValueConverter {
        protected final String format;
        protected final String xIsisFormat;
        private final Class<?>[] classes;

        public JsonValueConverter(String format, String xIsisFormat, Class<?> ... classes) {
            this.format = format;
            this.xIsisFormat = xIsisFormat;
            this.classes = classes;
        }

        public List<ObjectSpecId> getSpecIds() {
            return _NullSafe.stream((Object[])this.classes).map(cls -> ObjectSpecId.of((String)cls.getName())).collect(Collectors.toList());
        }

        public abstract ObjectAdapter asAdapter(JsonRepresentation var1, String var2);

        public Object appendValueAndFormat(ObjectAdapter objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
            Object value = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
            repr.mapPut("value", value);
            JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
            return value;
        }

        public Object asObject(ObjectAdapter objectAdapter, String format) {
            return objectAdapter.getPojo();
        }
    }

    public static class ExpectedStringRepresentingValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
    }
}

