/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class IsisLoggingConfigurer {
    private final Level rootLoggerLevelIfFallback;
    private boolean loggingSetup;

    public IsisLoggingConfigurer() {
        this(Level.WARN);
    }

    public IsisLoggingConfigurer(Level rootLoggerLevelIfFallback) {
        this.rootLoggerLevelIfFallback = rootLoggerLevelIfFallback;
    }

    public void configureLogging(String configDirectory, String[] args) {
        this.configureLoggingWithFile(configDirectory + "/" + "logging.properties", args);
    }

    public void configureLoggingWithFile(String configFile, String[] args) {
        if (this.loggingSetup) {
            return;
        }
        this.loggingSetup = true;
        this.configureLogging(configFile);
        IsisLoggingConfigurer.applyLoggingLevelFromCommandLine(args);
    }

    private static void applyLoggingLevelFromCommandLine(String[] args) {
        Level loggingLevel = IsisLoggingConfigurer.loggingLevel(args);
        if (loggingLevel != null) {
            Logger.getRootLogger().setLevel(loggingLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void configureLogging(String configFile) {
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(configFile);
            properties.load(inStream);
        }
        catch (IOException iOException) {
            IsisLoggingConfigurer.closeSafely(inStream);
            catch (Throwable throwable) {
                IsisLoggingConfigurer.closeSafely(inStream);
                throw throwable;
            }
        }
        IsisLoggingConfigurer.closeSafely(inStream);
        if (properties.size() == 0) {
            InputStream inStream2;
            block11: {
                inStream2 = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    inStream2 = classLoader.getResourceAsStream(configFile);
                    if (inStream2 == null) break block11;
                    properties.load(inStream2);
                }
                catch (IOException iOException) {
                    IsisLoggingConfigurer.closeSafely(inStream2);
                    catch (Throwable throwable) {
                        IsisLoggingConfigurer.closeSafely(inStream2);
                        throw throwable;
                    }
                }
            }
            IsisLoggingConfigurer.closeSafely(inStream2);
        }
        if (properties.size() > 0) {
            PropertyConfigurator.configure((Properties)properties);
        } else {
            this.configureFallbackLogging();
        }
    }

    private static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void configureFallbackLogging() {
        PatternLayout layout = new PatternLayout("%-5r [%-25.25c{1} %-10.10t %-5.5p]  %m%n");
        ConsoleAppender appender = new ConsoleAppender((Layout)layout);
        BasicConfigurator.configure((Appender)appender);
        Logger.getRootLogger().setLevel(this.rootLoggerLevelIfFallback);
        Logger.getLogger((String)"ui").setLevel(Level.OFF);
    }

    private static Level loggingLevel(String[] args) {
        Level level = null;
        for (String arg : args) {
            if (arg.equals("-debug")) {
                level = Level.DEBUG;
                break;
            }
            if (arg.equals("-quiet")) {
                level = Level.ERROR;
                break;
            }
            if (!arg.equals("-verbose")) continue;
            level = Level.INFO;
            break;
        }
        return level;
    }
}

