/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.plugins.environment;

import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.core.plugins.environment.DeploymentType;

public interface IsisSystemEnvironment {
    public static final IsisSystemEnvironment DEFAULT = new IsisSystemEnvironment(){
        private _Lazy<DeploymentType> deploymentType = _Lazy.threadSafe(this::decideDeploymentType);

        @Override
        public DeploymentType getDeploymentType() {
            return this.deploymentType.get();
        }

        @Override
        public boolean isUnitTesting() {
            return "true".equalsIgnoreCase(System.getProperty("UNITTESTING"));
        }

        private DeploymentType decideDeploymentType() {
            boolean anyVoteForPrototyping = false;
            boolean anyVoteForProduction = false;
            anyVoteForPrototyping |= "true".equalsIgnoreCase(System.getenv("PROTOTYPING"));
            anyVoteForPrototyping |= "true".equalsIgnoreCase(System.getProperty("PROTOTYPING"));
            anyVoteForProduction |= "false".equalsIgnoreCase(System.getProperty("PROTOTYPING"));
            boolean isPrototyping = (anyVoteForPrototyping |= "PROTOTYPING".equalsIgnoreCase(System.getProperty("isis.deploymentType"))) && !(anyVoteForProduction |= "PRODUCTION".equalsIgnoreCase(System.getProperty("isis.deploymentType")));
            DeploymentType deploymentType = isPrototyping ? DeploymentType.PROTOTYPING : DeploymentType.PRODUCTION;
            return deploymentType;
        }
    };

    public DeploymentType getDeploymentType();

    public boolean isUnitTesting();

    public static IsisSystemEnvironment getDefault() {
        return DEFAULT;
    }

    public static void setUnitTesting(boolean isUnitTesting) {
        System.setProperty("UNITTESTING", "" + isUnitTesting);
    }

    public static void setPrototyping(boolean isPrototyping) {
        System.setProperty("PROTOTYPING", "" + isPrototyping);
    }
}

