/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.resources._Resources_ContextPath;
import org.apache.isis.commons.internal.resources._Resources_RestfulPath;

public final class _Resources {
    private static final Predicate<String> externalResourcePattern = Pattern.compile("^\\w+?://.*$").asPredicate();

    public static InputStream load(Class<?> contextClass, String resourceName) {
        _With.requires(contextClass, "contextClass");
        _With.requires(resourceName, "resourceName");
        String absoluteResourceName = _Resources.resolveName(resourceName, contextClass);
        return _Context.getDefaultClassLoader().getResourceAsStream(absoluteResourceName);
    }

    public static String loadAsString(Class<?> contextClass, String resourceName, Charset charset) throws IOException {
        InputStream is = _Resources.load(contextClass, resourceName);
        return _Strings.ofBytes(_Bytes.of(is), charset);
    }

    public static URL getResourceUrl(Class<?> contextClass, String resourceName) {
        _With.requires(resourceName, "resourceName");
        String absoluteResourceName = _Resources.resolveName(resourceName, contextClass);
        return _Context.getDefaultClassLoader().getResource(absoluteResourceName);
    }

    public static final String getContextPathIfAny() {
        _Resources_ContextPath resource = _Context.getIfAny(_Resources_ContextPath.class);
        return resource != null ? resource.getContextPath() : null;
    }

    public static final void putContextPathIfPresent(String contextPath) {
        if (!_Strings.isEmpty(contextPath)) {
            _Context.put(_Resources_ContextPath.class, new _Resources_ContextPath(contextPath), false);
        }
    }

    public static final String prependContextPathIfPresent(String path) {
        if (path == null) {
            return null;
        }
        String contextPath = _Resources.getContextPathIfAny();
        if (contextPath == null) {
            return path;
        }
        if (!path.startsWith("/")) {
            return contextPath + "/" + path;
        }
        return "/" + contextPath + path;
    }

    public static final String getRestfulPathIfAny() {
        _Resources_RestfulPath resource = _Context.getIfAny(_Resources_RestfulPath.class);
        return resource != null ? resource.getRestfulPath() : null;
    }

    public static final String getRestfulPathOrThrow() {
        return _With.ifPresentElseThrow(_Resources.getRestfulPathIfAny(), () -> new NullPointerException("Could not find BasePath for the REST Service config value on the context."));
    }

    public static final void putRestfulPath(String restfulPath) {
        _Context.put(_Resources_RestfulPath.class, new _Resources_RestfulPath(restfulPath), false);
    }

    public static boolean isLocalResource(String resourcePath) {
        _With.requires(resourcePath, "resourcePath");
        return !externalResourcePattern.test(resourcePath);
    }

    public static String combinePath(@Nullable String extendee, @Nullable String suffix) {
        return _Strings.combineWithDelimiter(extendee, suffix, "/");
    }

    private static String resolveName(String name, Class<?> contextClass) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            Class<?> c = contextClass;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }
}

