/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Arrays;

public final class _Reflect {
    private _Reflect() {
    }

    public static boolean same(Method method, Method superMethod) {
        if (!method.getName().equals(superMethod.getName())) {
            return false;
        }
        if (method.getParameterCount() != superMethod.getParameterCount()) {
            return false;
        }
        return _Arrays.testAllMatch(method.getParameters(), superMethod.getParameters(), (p1, p2) -> p1.getType().equals(p2.getType()));
    }

    public static boolean isAccessible(Member m) {
        return m != null && Modifier.isPublic(m.getModifiers()) && !m.isSynthetic();
    }

    public static <T extends Member> Predicate<T> withName(String memberName) {
        _With.requires(memberName, "memberName");
        return m -> m != null && memberName.equals(m.getName());
    }

    public static <T extends Member> Predicate<T> withPrefix(String prefix) {
        _With.requires(prefix, "prefix");
        return m -> m != null && m.getName().startsWith(prefix);
    }

    public static Predicate<Method> withMethodParametersCount(int count) {
        return m -> m != null && m.getParameterTypes().length == count;
    }

    public static <T> Predicate<Field> withTypeAssignableTo(Class<T> type) {
        _With.requires(type, "type");
        return f -> f != null && type.isAssignableFrom(f.getType());
    }

    public static Stream<Field> streamFields(@Nullable Class<?> type, boolean ignoreAccess) {
        if (type == null) {
            return Stream.empty();
        }
        if (ignoreAccess) {
            return _NullSafe.stream(type.getDeclaredFields());
        }
        return _NullSafe.stream(type.getFields());
    }

    public static Stream<Field> streamAllFields(@Nullable Class<?> type, boolean ignoreAccess) {
        return _Reflect.streamTypeHierarchy(type, false).filter(Object.class::equals).flatMap(t -> _Reflect.streamFields(t, ignoreAccess));
    }

    public static Stream<Method> streamMethods(@Nullable Class<?> type, boolean ignoreAccess) {
        if (type == null) {
            return Stream.empty();
        }
        if (ignoreAccess) {
            return _NullSafe.stream(type.getDeclaredMethods());
        }
        return _NullSafe.stream(type.getMethods());
    }

    public static Stream<Method> streamAllMethods(@Nullable Class<?> type, boolean ignoreAccess) {
        return _Reflect.streamTypeHierarchy(type, true).filter(t -> !t.equals(Object.class)).flatMap(t -> _Reflect.streamMethods(t, ignoreAccess));
    }

    public static Stream<Class<?>> streamTypeHierarchy(final @Nullable Class<?> type, final boolean includeInterfaces) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<Class<?>>(Long.MAX_VALUE, 1296){
            Class<?> current;
            {
                super(x0, x1);
                this.current = type;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Class<?>> action) {
                if (this.current == null) {
                    return false;
                }
                action.accept(this.current);
                if (includeInterfaces) {
                    for (Class<?> subIface : this.current.getInterfaces()) {
                        this.recur(subIface, action);
                    }
                }
                this.current = this.current.getSuperclass();
                return true;
            }

            private void recur(Class<?> iface, Consumer<? super Class<?>> action) {
                action.accept(iface);
                for (Class<?> subIface : iface.getInterfaces()) {
                    this.recur(subIface, action);
                }
            }
        }, false);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = _Reflect.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException annotationFromSuperclass) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = _Reflect.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        _With.requires(method, "method");
        _With.requires(annotationCls, "annotationCls");
        if (!ignoreAccess && !_Reflect.isAccessible(method)) {
            return null;
        }
        Stream<Method> methods = searchSupers ? _Reflect.streamAllMethods(method.getDeclaringClass(), ignoreAccess) : _Reflect.streamMethods(method.getDeclaringClass(), ignoreAccess);
        return (A)((Annotation)methods.filter(m -> _Reflect.same(method, m)).map(m -> m.getAnnotation(annotationCls)).filter(_NullSafe::isPresent).findFirst().orElse(null));
    }
}

