/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.memento;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.memento._Mementos;

class _Mementos_MementoDefault
implements _Mementos.Memento {
    private final _Mementos.EncoderDecoder codec;
    private final _Mementos.SerializingAdapter serializer;
    private final Map<String, Serializable> valuesByKey;

    _Mementos_MementoDefault(_Mementos.EncoderDecoder codec, _Mementos.SerializingAdapter serializer) {
        this(codec, serializer, _Maps.newHashMap());
    }

    private _Mementos_MementoDefault(_Mementos.EncoderDecoder codec, _Mementos.SerializingAdapter serializer, Map<String, Serializable> valuesByKey) {
        this.codec = _With.requires(codec, "codec");
        this.serializer = _With.requires(serializer, "serializer");
        this.valuesByKey = _With.requires(valuesByKey, "valuesByKey");
    }

    @Override
    public _Mementos.Memento put(String name, Object value) {
        if (value == null) {
            return this;
        }
        _With.requires(name, "name");
        this.valuesByKey.put(name, this.serializer.write(value));
        return this;
    }

    @Override
    public <T> T get(String name, Class<T> cls) {
        Serializable value = this.valuesByKey.get(name);
        if (value == null) {
            return null;
        }
        return this.serializer.read(cls, value);
    }

    @Override
    public Set<String> keySet() {
        return _Sets.unmodifiable(this.valuesByKey.keySet());
    }

    @Override
    public String asString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(16384);
        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
            oos.writeObject(this.valuesByKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to serialize memento", e);
        }
        return this.codec.encode(os.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static _Mementos.Memento parse(_Mementos.EncoderDecoder codec, _Mementos.SerializingAdapter serializer, @Nullable String str) {
        _With.requires(codec, "codec");
        if (_NullSafe.isEmpty(str)) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(codec.decode(str))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String name = desc.getName();
                return Class.forName(name, false, _Context.getDefaultClassLoader());
            }
        };){
            Map valuesByKey = (Map)_Casts.uncheckedCast(ois.readObject());
            _Mementos_MementoDefault _Mementos_MementoDefault2 = new _Mementos_MementoDefault(codec, serializer, valuesByKey);
            return _Mementos_MementoDefault2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse memento from serialized string", e);
        }
    }
}

