/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.functions;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.isis.commons.internal.functions._Functions_IndexAwareFunctionAdapter;

public final class _Functions {
    public static <T, R> Function<T, R> indexAwareToFunction(IndexAwareFunction<T, R> indexAwareFunction) {
        return new _Functions_IndexAwareFunctionAdapter<T, R>(indexAwareFunction);
    }

    public static <T, R, U extends RuntimeException> Function<T, R> uncheckedFunction(CheckedFunction<T, R> checkedFunction, Function<Exception, U> toUncheckedException) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <U extends RuntimeException> Runnable uncheckedRunnable(CheckedRunnable checkedRunnable, Function<Exception, U> toUncheckedException) {
        return () -> {
            try {
                checkedRunnable.run();
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <T, U extends RuntimeException> Consumer<T> uncheckedConsumer(CheckedConsumer<T> checkedConsumer, Function<Exception, U> toUncheckedException) {
        return t -> {
            try {
                checkedConsumer.accept(t);
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <T, U extends RuntimeException> Supplier<T> uncheckedSupplier(CheckedSupplier<T> checkedSupplier, Function<Exception, U> toUncheckedException) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Exception;

        default public <U extends RuntimeException> Supplier<T> toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedSupplier(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;

        default public <U extends RuntimeException> Consumer<T> toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedConsumer(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Exception;

        default public <U extends RuntimeException> Runnable toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedRunnable(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;

        default public <U extends RuntimeException> Function<T, R> toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedFunction(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface IndexAwareFunction<T, R> {
        public R apply(int var1, T var2);
    }
}

