/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.context;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.plugins.PluginResolveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class _Plugin {
    private _Plugin() {
    }

    public static <S> Set<S> loadAll(Class<S> service) {
        _With.requires(service, "service");
        ServiceLoader<S> loader = ServiceLoader.load(service, _Context.getDefaultClassLoader());
        return _Sets.unmodifiable(loader);
    }

    public static <S> S getOrElse(Class<S> pluginClass, Function<Set<S>, S> onAmbiguity, Supplier<S> onNotFound) {
        return (S)_Context.computeIfAbsent(pluginClass, __ -> {
            Set plugins = _Plugin.loadAll(pluginClass);
            if (plugins.isEmpty()) {
                return onNotFound.get();
            }
            if (plugins.size() > 1) {
                return onAmbiguity.apply(plugins);
            }
            return plugins.iterator().next();
        });
    }

    public static <T> T pickAnyAndWarn(Class<T> pluginInterfaceClass, Set<T> ambiguousPlugins) {
        Logger log = LoggerFactory.getLogger(pluginInterfaceClass);
        T any = ambiguousPlugins.iterator().next();
        log.warn(String.format("You have more than one plugin implementing '%s' on your class-path [%s], just picking one: '%s'", pluginInterfaceClass.getName(), ambiguousPlugins.stream().map(p -> p.getClass().getName()).collect(Collectors.joining(", ")), any.getClass().getName()));
        return any;
    }

    public static <T> PluginResolveException ambiguityNonRecoverable(Class<T> pluginInterfaceClass, Set<? extends T> ambiguousPlugins) {
        return new PluginResolveException(String.format("Ambiguous plugins implementing %s found on class path.\n{%s}", pluginInterfaceClass.getName(), _NullSafe.stream(ambiguousPlugins).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "))));
    }

    public static PluginResolveException absenceNonRecoverable(Class<?> pluginInterfaceClass) {
        return new PluginResolveException(String.format("No plugin implementing %s found on class path.", pluginInterfaceClass.getName()));
    }

    public static <S> S load(Class<S> pluginInterfaceClass, File classPath, String pluginFullyQualifiedClassName) {
        try {
            ClassLoader parentCL = pluginInterfaceClass.getClassLoader();
            URL[] urls = new URL[]{classPath.toURI().toURL()};
            URLClassLoader cl = URLClassLoader.newInstance(urls, parentCL);
            Class pluginClass = (Class)_Casts.uncheckedCast(cl.loadClass(pluginFullyQualifiedClassName));
            Object plugin = pluginClass.newInstance();
            _Context.putSingleton(pluginInterfaceClass, plugin);
            return (S)plugin;
        }
        catch (Exception e) {
            throw new PluginResolveException(String.format("Failed to load plugin '%s' implementing '%s' from path '%s'.", pluginFullyQualifiedClassName, pluginInterfaceClass.getName(), classPath.getAbsolutePath()), e);
        }
    }
}

