/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.plugins.environment.IsisSystemEnvironment;
import org.apache.isis.core.plugins.environment.IsisSystemEnvironmentPlugin;

public final class _Context {
    private static final Map<String, Object> singletonMap = new HashMap<String, Object>();
    private static final Supplier<ClassLoader> FALLBACK_CLASSLOADER = Thread.currentThread()::getContextClassLoader;

    private _Context() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void putSingleton(Class<? super T> type, T singleton) {
        _With.requires(type, "type");
        _With.requires(singleton, "singleton");
        Map<String, Object> map = singletonMap;
        synchronized (map) {
            if (singletonMap.containsKey(_Context.toKey(type))) {
                throw new IllegalStateException("there is already a singleton of type '" + type + "' on this context.");
            }
            singletonMap.put(_Context.toKey(type), singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean put(Class<? super T> type, T singleton, boolean override) {
        _With.requires(type, "type");
        _With.requires(singleton, "singleton");
        Map<String, Object> map = singletonMap;
        synchronized (map) {
            if (singletonMap.containsKey(_Context.toKey(type)) && !override) {
                return false;
            }
            singletonMap.put(_Context.toKey(type), singleton);
            return true;
        }
    }

    public static <T> T getIfAny(Class<? super T> type) {
        return _Casts.uncheckedCast(singletonMap.get(_Context.toKey(type)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeIfAbsent(Class<? super T> type, Function<Class<? super T>, T> factory) {
        _With.requires(type, "type");
        _With.requires(factory, "factory");
        String key = _Context.toKey(type);
        Map<String, Object> map = singletonMap;
        synchronized (map) {
            Object existingIfAny = _Casts.uncheckedCast(singletonMap.get(key));
            if (existingIfAny != null) {
                return existingIfAny;
            }
            T t = factory.apply(type);
            singletonMap.put(key, t);
            return t;
        }
    }

    public static <T> T getOrElse(Class<? super T> type, Supplier<T> fallback) {
        _With.requires(fallback, "fallback");
        return _With.ifPresentElseGet(_Context.getIfAny(type), fallback);
    }

    public static <T, E extends Exception> T getOrThrow(Class<? super T> type, Supplier<E> onNotFound) throws E {
        _With.requires(onNotFound, "onNotFound");
        return _With.ifPresentElseThrow(_Context.getIfAny(type), onNotFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Class<?> type) {
        Map<String, Object> map = singletonMap;
        synchronized (map) {
            singletonMap.remove(_Context.toKey(type));
        }
        _Context.tryClose(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Object> map = singletonMap;
        synchronized (map) {
            _Context.closeAnyClosables(_Lists.newArrayList(singletonMap.values()));
            singletonMap.clear();
        }
    }

    private static void closeAnyClosables(List<Object> objects) {
        _NullSafe.stream(objects).forEach(_Context::tryClose);
    }

    public static ClassLoader getDefaultClassLoader() {
        return _Context.getOrElse(ClassLoader.class, FALLBACK_CLASSLOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultClassLoader(ClassLoader classLoader, boolean override) {
        boolean alreadyRegistered;
        boolean bl = alreadyRegistered = _Context.getIfAny(ClassLoader.class) != null;
        if (!alreadyRegistered || override) {
            Map<String, Object> map = singletonMap;
            synchronized (map) {
                singletonMap.put(_Context.toKey(ClassLoader.class), _With.requires(classLoader, "classLoader"));
            }
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return _Context.getDefaultClassLoader().loadClass(className);
    }

    public static Class<?> loadClassAndInitialize(String className) throws ClassNotFoundException {
        return Class.forName(className, true, _Context.getDefaultClassLoader());
    }

    public static IsisSystemEnvironment getEnvironment() {
        return _Context.getOrElse(IsisSystemEnvironment.class, IsisSystemEnvironmentPlugin.get()::getIsisSystemEnvironment);
    }

    public static boolean isPrototyping() {
        return _Context.getEnvironment().getDeploymentType().isPrototyping();
    }

    public static boolean isUnitTesting() {
        return _Context.getEnvironment().isUnitTesting();
    }

    private static String toKey(Class<?> type) {
        return type.getName();
    }

    private static void tryClose(Object singleton) {
        if (singleton == null) {
            return;
        }
        if (singleton instanceof AutoCloseable) {
            try {
                ((AutoCloseable)singleton).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

