/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.compare;

import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._Strings;

final class _Comparators_SequenceCompare {
    private _Comparators_SequenceCompare() {
    }

    public static int compareNullLast(@Nullable String sequence1, @Nullable String sequence2, String separator) {
        if (_Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("a non empty separator is required");
        }
        if (sequence1 == null && sequence2 == null) {
            return 0;
        }
        if (sequence1 == null && sequence2 != null) {
            return 1;
        }
        if (sequence1 != null && sequence2 == null) {
            return -1;
        }
        StringTokenizer components1 = _Comparators_SequenceCompare.tokenizerFor(sequence1, separator);
        StringTokenizer components2 = _Comparators_SequenceCompare.tokenizerFor(sequence2, separator);
        int length1 = components1.countTokens();
        int length2 = components2.countTokens();
        if (length1 == 0 && length2 == 0) {
            return 0;
        }
        int n = 0;
        int length;
        while (length1 >= (length = n + 1) || length2 < length) {
            if (length2 < length && length1 >= length) {
                return 1;
            }
            if (length1 < length && length2 < length) {
                return 0;
            }
            String token1 = components1.nextToken();
            String token2 = components2.nextToken();
            int componentCompare = 0;
            try {
                int c1 = Integer.parseInt(token1);
                int c2 = Integer.parseInt(token2);
                componentCompare = Integer.compare(c1, c2);
            }
            catch (NumberFormatException nfe) {
                componentCompare = token1.compareTo(token2);
            }
            if (componentCompare != 0) {
                return componentCompare;
            }
            ++n;
        }
        return -1;
    }

    private static StringTokenizer tokenizerFor(String sequence, String separator) {
        return new StringTokenizer(sequence, separator, false);
    }
}

