/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Multimaps;

public final class _Maps {
    private _Maps() {
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        mapPreservingOrder.put(k2, v2);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        mapPreservingOrder.put(k2, v2);
        mapPreservingOrder.put(k3, v3);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        mapPreservingOrder.put(k2, v2);
        mapPreservingOrder.put(k3, v3);
        mapPreservingOrder.put(k4, v4);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> unmodifiableEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        _With.requires(entries, "entries");
        if (entries.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap mapPreservingOrder = _Maps.newLinkedHashMap();
        Stream.of(entries).forEach(entry -> mapPreservingOrder.put(entry.getKey(), entry.getValue()));
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    public static <K, V> Map<K, V> filterKeys(@Nullable Map<K, V> input, Predicate<K> keyFilter, Supplier<Map<K, V>> factory) {
        _With.requires(factory, "factory");
        Map result = factory.get();
        if (input == null) {
            return result;
        }
        _With.requires(keyFilter, "keyFilter");
        input.forEach((k, v) -> {
            if (keyFilter.test(k)) {
                result.put(k, v);
            }
        });
        return result;
    }

    public static <K, V> _Multimaps.ListMultimap<V, K> invertToListMultimap(Map<K, V> input) {
        _Multimaps.ListMultimap result = _Multimaps.newListMultimap();
        if (input == null) {
            return result;
        }
        input.forEach((k, v) -> result.putElement(v, k));
        return result;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }
}

