/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Arrays_Collector;
import org.apache.isis.commons.internal.collections._Arrays_CollectorUnknownSize;
import org.apache.isis.commons.internal.collections._Collections;

public final class _Arrays {
    private _Arrays() {
    }

    public static <T> boolean testAnyMatch(@Nullable T[] array1, @Nullable T[] array2, BiPredicate<T, T> test) {
        int s2;
        int s1 = _NullSafe.size(array1);
        if (s1 != (s2 = _NullSafe.size(array2))) {
            throw new IllegalArgumentException("Array length missmatch");
        }
        if (s1 == 0) {
            return false;
        }
        _With.requires(test, "test");
        for (int i = 0; i < s1; ++i) {
            if (!test.test(array1[i], array2[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean testAllMatch(@Nullable T[] array1, @Nullable T[] array2, BiPredicate<T, T> test) {
        _With.requires(test, "test");
        return !_Arrays.testAnyMatch(array1, array2, test.negate());
    }

    public static boolean isArrayType(@Nullable Class<?> cls) {
        return cls != null ? cls.isArray() : false;
    }

    public static boolean isCollectionOrArrayType(Class<?> cls) {
        return _Collections.isCollectionType(cls) || _Arrays.isArrayType(cls);
    }

    public static <T> Collector<T, ?, T[]> toArray(Class<T> componentType, int length) {
        _With.requires(componentType, "componentType");
        return new _Arrays_Collector<T>(componentType, length);
    }

    public static <T> Collector<T, ?, T[]> toArray(Class<T> componentType) {
        _With.requires(componentType, "componentType");
        return new _Arrays_CollectorUnknownSize<T>(componentType);
    }

    @SafeVarargs
    public static <T> T[] combine(T first, T ... rest) {
        _With.requires(first, "first");
        int restLength = _NullSafe.size(rest);
        Object[] all = (Object[])_Casts.uncheckedCast(Array.newInstance(first.getClass(), restLength + 1));
        all[0] = first;
        if (restLength > 0) {
            System.arraycopy(rest, 0, all, 1, restLength);
        }
        return all;
    }

    @SafeVarargs
    public static <T> T[] combine(T[] first, T ... rest) {
        int restLength;
        int firstLength = _NullSafe.size(first);
        if (firstLength + (restLength = _NullSafe.size(rest)) == 0) {
            return (Object[])_Casts.uncheckedCast(_Constants.emptyObjects);
        }
        Class<?> componentType = firstLength > 0 ? first[0].getClass() : rest[0].getClass();
        Object[] all = (Object[])_Casts.uncheckedCast(Array.newInstance(componentType, firstLength + restLength));
        System.arraycopy(first, 0, all, 0, firstLength);
        System.arraycopy(rest, 0, all, firstLength, restLength);
        return all;
    }

    public static <T> T[] toArray(@Nullable Collection<? extends T> collection, Class<T> componentType) {
        _With.requires(componentType, "componentType");
        return _NullSafe.stream(collection).collect(_Arrays.toArray(componentType, collection != null ? collection.size() : 0));
    }

    public static <T> T[] toArray(@Nullable Iterable<? extends T> iterable, Class<T> componentType) {
        _With.requires(componentType, "componentType");
        if (iterable != null && iterable instanceof Collection) {
            return _Arrays.toArray((Collection)iterable, componentType);
        }
        return _NullSafe.stream(iterable).collect(_Arrays.toArray(componentType));
    }

    @Nullable
    public static Class<?> inferComponentTypeIfAny(@Nullable Class<?> arrayType) {
        if (!_Arrays.isArrayType(arrayType)) {
            return null;
        }
        return arrayType.getComponentType();
    }
}

