/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.cdi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Qualifier;
import org.apache.isis.commons.internal.base._NullSafe;

public final class _CDI {
    public static <T> Optional<T> getManagedBean(Class<T> subType, List<Annotation> qualifiers) {
        if (_NullSafe.isEmpty(qualifiers)) {
            return _CDI.getManagedBean(subType);
        }
        Annotation[] _qualifiers = qualifiers.toArray(new Annotation[0]);
        return _CDI.cdi().map(cdi -> _CDI.tryGet(() -> cdi.select(subType, _qualifiers))).map(instance -> _CDI.tryGet(() -> ((Instance)instance).get()));
    }

    public static <T> Optional<T> getManagedBean(Class<T> subType) {
        return _CDI.cdi().map(cdi -> _CDI.tryGet(() -> cdi.select(subType, new Annotation[0]))).map(instance -> _CDI.tryGet(() -> ((Instance)instance).get()));
    }

    public static Optional<CDI<Object>> cdi() {
        try {
            CDI cdi = CDI.current();
            return Optional.ofNullable(cdi);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static List<Annotation> filterQualifiers(Annotation[] annotations) {
        return _NullSafe.stream(annotations).filter(_CDI::isQualifier).collect(Collectors.toList());
    }

    public static boolean isQualifier(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        return ((Qualifier[])annotation.annotationType().getAnnotationsByType(Qualifier.class)).length > 0;
    }

    private _CDI() {
    }

    private static <T> T tryGet(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return null;
        }
    }
}

