/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

public final class _Timing {
    private _Timing() {
    }

    public static StopWatch now() {
        return new StopWatch();
    }

    public static StopWatch atSystemNanos(long startedAtSystemNanos) {
        return new StopWatch(startedAtSystemNanos);
    }

    public static final class StopWatch {
        private long t0 = 0L;
        private long t1 = 0L;
        private boolean stopped;

        private StopWatch(long startedAtSystemNanos) {
            this.t0 = startedAtSystemNanos;
        }

        private StopWatch() {
            this.start();
        }

        public StopWatch start() {
            this.t0 = System.nanoTime();
            this.stopped = false;
            return this;
        }

        public StopWatch stop() {
            this.t1 = System.nanoTime();
            this.stopped = true;
            return this;
        }

        public double getSeconds() {
            return 1.0E-9 * (double)this.getNanos();
        }

        public double getMillis() {
            return 1.0E-6 * (double)this.getNanos();
        }

        public double getMicros() {
            return 0.001 * (double)this.getNanos();
        }

        public long getNanos() {
            return this.stopped ? this.t1 - this.t0 : System.nanoTime() - this.t0;
        }
    }
}

