/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings_HtmlEscaper;
import org.apache.isis.commons.internal.base._Strings_KeyValuePair;
import org.apache.isis.commons.internal.base._Strings_NaturalNames;
import org.apache.isis.commons.internal.base._Strings_SplitIterator;
import org.apache.isis.commons.internal.base._With;

public final class _Strings {
    public static final String[] emptyArray = new String[0];
    public static final StringOperator asLowerDashed = _Strings.operator().andThen(_Strings::lower).andThen(s -> _Strings.condenseWhitespaces(s, "-"));
    public static final StringOperator asNormalized = _Strings.operator().andThen(s -> _Strings.condenseWhitespaces(s, " "));
    public static final StringOperator asNaturalName2 = _Strings.operator().andThen(s -> _Strings_NaturalNames.naturalName2(s, true));

    private _Strings() {
    }

    public static KeyValuePair pair(String key, String value) {
        return _Strings_KeyValuePair.of(key, value);
    }

    public static Optional<KeyValuePair> parseKeyValuePair(@Nullable String keyValueLiteral) {
        return _Strings_KeyValuePair.parse(keyValueLiteral);
    }

    public static String of(int length, char c) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        Arrays.fill(chars, c);
        return String.valueOf(chars);
    }

    public static boolean isEmpty(@Nullable CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence x) {
        return x != null && x.length() != 0;
    }

    @Nullable
    public static String emptyToNull(@Nullable String input) {
        if (_Strings.isEmpty(input)) {
            return null;
        }
        return input;
    }

    public static String nullToEmpty(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public static String trim(@Nullable String input) {
        return _With.mapIfPresentElse(input, String::trim, null);
    }

    public static String lower(@Nullable String input) {
        return _With.mapIfPresentElse(input, String::toLowerCase, null);
    }

    public static String upper(@Nullable String input) {
        return _With.mapIfPresentElse(input, String::toUpperCase, null);
    }

    public static String capitalize(@Nullable String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        if (input.length() == 1) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    public static String htmlEscape(String source) {
        return _Strings_HtmlEscaper.htmlEscape(source);
    }

    public static String prefix(@Nullable String input, String prefix) {
        if (input == null) {
            return null;
        }
        _With.requires(prefix, "prefix");
        if (input.startsWith(prefix)) {
            return input;
        }
        return prefix + input;
    }

    public static String suffix(@Nullable String input, String suffix) {
        if (input == null) {
            return null;
        }
        _With.requires(suffix, "suffix");
        if (input.endsWith(suffix)) {
            return input;
        }
        return input + suffix;
    }

    public static String combineWithDelimiter(@Nullable String left, @Nullable String right, String delimiter) {
        _With.requiresNotEmpty(delimiter, "pathDelimiter");
        if (_Strings.isNullOrEmpty(left) && _Strings.isNullOrEmpty(right)) {
            return "";
        }
        if (_Strings.isNullOrEmpty(left)) {
            return right;
        }
        if (_Strings.isNullOrEmpty(right)) {
            return left;
        }
        if (left.endsWith(delimiter) || right.startsWith(delimiter)) {
            return left + right;
        }
        return left + delimiter + right;
    }

    public static String padStart(@Nullable String str, int minLength, char c) {
        if (minLength <= 0) {
            return str;
        }
        int len = _NullSafe.size(str);
        if (len >= minLength) {
            return str;
        }
        int fillCount = minLength - len;
        return _Strings.of(fillCount, c) + _Strings.nullToEmpty(str);
    }

    public static String padEnd(@Nullable String str, int minLength, char c) {
        if (minLength <= 0) {
            return str;
        }
        int len = _NullSafe.size(str);
        if (len >= minLength) {
            return str;
        }
        int fillCount = minLength - len;
        return _Strings.nullToEmpty(str) + _Strings.of(fillCount, c);
    }

    public static Stream<String> splitThenStream(@Nullable String input, String separator) {
        if (_Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("a non empty separator is required");
        }
        if (_Strings.isEmpty(input)) {
            return Stream.of(new String[0]);
        }
        if (!input.contains(separator)) {
            return Stream.of(input);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(_Strings_SplitIterator.splitIterator(input, separator), 16), false);
    }

    public static Stream<String> splitThenStream(@Nullable CharSequence input, Pattern delimiterPattern) {
        _With.requires(delimiterPattern, "delimiterPattern");
        if (_Strings.isEmpty(input)) {
            return Stream.of(new String[0]);
        }
        return delimiterPattern.splitAsStream(input);
    }

    public static String condenseWhitespaces(@Nullable String input, String replacement) {
        _With.requires(replacement, "replacement");
        return _With.mapIfPresentElse(input, __ -> input.replaceAll("\\s+", replacement), null);
    }

    public static String read(@Nullable InputStream input, Charset charset) {
        _With.requires(charset, "charset");
        if (input == null) {
            return "";
        }
        try (Scanner scanner = new Scanner(input, charset.name());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public static final byte[] toBytes(@Nullable String str, Charset charset) {
        _With.requires(charset, "charset");
        return _With.mapIfPresentElse(str, __ -> str.getBytes(charset), null);
    }

    public static final String ofBytes(@Nullable byte[] bytes, Charset charset) {
        _With.requires(charset, "charset");
        return _With.mapIfPresentElse(bytes, __ -> new String(bytes, charset), null);
    }

    public static final String convert(@Nullable String input, _Bytes.BytesOperator converter, Charset charset) {
        _With.requires(converter, "converter");
        _With.requires(charset, "charset");
        return _With.mapIfPresentElse(input, __ -> _Strings.ofBytes(converter.apply(_Strings.toBytes(input, charset)), charset), null);
    }

    public static StringOperator operator() {
        return new StringOperator(UnaryOperator.identity());
    }

    public static final String asFileNameWithExtension(String fileName, String fileExtension) {
        _With.requires(fileName, "fileName");
        _With.requires(fileExtension, "fileExtension");
        return _Strings.suffix(fileName, _Strings.prefix(fileExtension, "."));
    }

    public static final class StringOperator {
        private final UnaryOperator<String> operator;

        private StringOperator(UnaryOperator<String> operator) {
            this.operator = _With.requires(operator, "operator");
        }

        public String apply(String input) {
            return (String)this.operator.apply(input);
        }

        public StringOperator andThen(UnaryOperator<String> andThen) {
            return new StringOperator(s -> (String)andThen.apply((String)this.operator.apply((String)s)));
        }
    }

    public static interface KeyValuePair
    extends Map.Entry<String, String> {
    }
}

