/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class _NullSafe {
    private _NullSafe() {
    }

    public static <T> Stream<T> stream(T[] array) {
        return array != null ? Stream.of(array) : Stream.empty();
    }

    public static <T> Stream<T> streamNullable(T nullable) {
        return nullable != null ? Stream.of(nullable) : Stream.empty();
    }

    public static <T> Stream<T> stream(Collection<T> coll) {
        return coll != null ? coll.stream() : Stream.empty();
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return iterable != null ? _NullSafe.stream(iterable.iterator()) : Stream.empty();
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return iterator != null ? StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false) : Stream.empty();
    }

    public static <T> Stream<T> stream(Enumeration<T> enumeration) {
        return enumeration != null ? _NullSafe.stream(_NullSafe.toIterator(enumeration)) : Stream.empty();
    }

    private static <T> Iterator<T> toIterator(final Enumeration<T> e) {
        return new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        };
    }

    public static boolean isPresent(Object x) {
        return x != null;
    }

    public static boolean isAbsent(Object x) {
        return x == null;
    }

    public static boolean equals(Object x, Object y) {
        return Objects.equals(x, y);
    }

    public static <T extends Comparable<T>> int compareNullsFirst(T x, T y) {
        return Objects.compare(x, y, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    public static <T extends Comparable<T>> int compareNullsLast(T x, T y) {
        return Objects.compare(x, y, Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public static boolean isEmpty(String x) {
        return x == null || x.length() == 0;
    }

    public static boolean isEmpty(Collection<?> x) {
        return x == null || x.size() == 0;
    }

    public static boolean isEmpty(Map<?, ?> x) {
        return x == null || x.size() == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static int size(String x) {
        return x != null ? x.length() : 0;
    }

    public static int size(Collection<?> x) {
        return x != null ? x.size() : 0;
    }

    public static int size(Map<?, ?> x) {
        return x != null ? x.size() : 0;
    }

    public static int size(boolean[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(byte[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(char[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(double[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(float[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(int[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(long[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(short[] array) {
        return array != null ? array.length : 0;
    }

    public static <T> int size(T[] array) {
        return array != null ? array.length : 0;
    }

    public static final <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        if (map == null || key == null) {
            return defaultValue;
        }
        return map.getOrDefault(key, defaultValue);
    }
}

