/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.security.shiro.permrolemapper;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.isis.security.shiro.permrolemapper.PermissionToRoleMapper;
import org.apache.shiro.config.Ini;
import org.apache.shiro.util.PermissionUtils;

public class PermissionToRoleMapperFromIni
implements PermissionToRoleMapper {
    private final Map<String, Set<String>> permissionsByRole;

    public PermissionToRoleMapperFromIni(Ini ini) {
        Ini.Section section = ini.getSection("roles");
        this.permissionsByRole = Collections.unmodifiableMap(section.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PermissionUtils.toPermissionStrings((String)((String)entry.getValue())))));
    }

    @Override
    public Map<String, Set<String>> getPermissionsByRole() {
        return this.permissionsByRole;
    }
}

