/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.security.shiro.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;

public class IsisPermission
extends WildcardPermission {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("([!]?)([^/]+)[/](.+)");
    private static ThreadLocal<Map<String, List<IsisPermission>>> VETOING_PERMISSIONS = new ThreadLocal<Map<String, List<IsisPermission>>>(){

        @Override
        protected Map<String, List<IsisPermission>> initialValue() {
            return _Maps.newTreeMap();
        }
    };
    private boolean veto;
    private String permissionGroup;

    public static void resetVetoedPermissions() {
        VETOING_PERMISSIONS.get().clear();
    }

    static boolean isVetoed(String permissionGroup, Permission p) {
        if (permissionGroup == null) {
            return false;
        }
        List<IsisPermission> vetoingPermissions = VETOING_PERMISSIONS.get().get(permissionGroup);
        if (vetoingPermissions == null || vetoingPermissions.isEmpty()) {
            return false;
        }
        for (IsisPermission vetoingPermission : vetoingPermissions) {
            if (!vetoingPermission.impliesWithoutVeto(p)) continue;
            return true;
        }
        return false;
    }

    static void addVeto(IsisPermission vetoingPermission) {
        String permissionGroup = vetoingPermission.getPermissionGroup();
        ArrayList vetoingPermissions = VETOING_PERMISSIONS.get().get(permissionGroup);
        if (vetoingPermissions == null) {
            vetoingPermissions = _Lists.newArrayList();
            VETOING_PERMISSIONS.get().put(permissionGroup, vetoingPermissions);
        }
        vetoingPermissions.add(vetoingPermission);
    }

    public IsisPermission() {
    }

    public IsisPermission(String wildcardString, boolean caseSensitive) {
        super(wildcardString, caseSensitive);
    }

    public IsisPermission(String wildcardString) {
        super(wildcardString);
    }

    protected void setParts(String wildcardString, boolean caseSensitive) {
        Matcher matcher = PATTERN.matcher(wildcardString);
        if (matcher.matches()) {
            this.veto = matcher.group(1).length() > 0;
            this.permissionGroup = matcher.group(2);
            super.setParts(matcher.group(3), caseSensitive);
        } else {
            super.setParts(wildcardString, caseSensitive);
        }
    }

    public boolean implies(Permission p) {
        if (this.veto) {
            IsisPermission.addVeto(this);
            return false;
        }
        return !IsisPermission.isVetoed(this.permissionGroup, p) && super.implies(p);
    }

    boolean impliesWithoutVeto(Permission p) {
        return super.implies(p);
    }

    String getPermissionGroup() {
        return this.permissionGroup;
    }

    public boolean equals(Object other) {
        if (other instanceof IsisPermission) {
            IsisPermission ip = (IsisPermission)((Object)other);
            return this.permissionGroup.equals(ip.getPermissionGroup()) && super.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return (this.veto ? "!" : "") + (this.permissionGroup != null ? this.permissionGroup + "/" : "") + super.toString();
    }
}

