/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.Dom4JReader;
import com.thoughtworks.xstream.io.xml.XomReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import nu.xom.Document;
import org.axonframework.serialization.AbstractXStreamSerializer;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.xml.CompactDriver;
import org.axonframework.serialization.xml.Dom4JToByteArrayConverter;
import org.axonframework.serialization.xml.InputStreamToDom4jConverter;
import org.axonframework.serialization.xml.InputStreamToXomConverter;
import org.axonframework.serialization.xml.XomToStringConverter;

public class XStreamSerializer
extends AbstractXStreamSerializer {
    public XStreamSerializer() {
        super(new XStream((HierarchicalStreamDriver)new CompactDriver()));
    }

    public XStreamSerializer(RevisionResolver revisionResolver) {
        this(new XStream((HierarchicalStreamDriver)new CompactDriver()), revisionResolver);
    }

    public XStreamSerializer(XStream xStream) {
        super(xStream);
    }

    public XStreamSerializer(XStream xStream, RevisionResolver revisionResolver) {
        super(xStream, revisionResolver);
    }

    public XStreamSerializer(Charset charset) {
        super(charset, new XStream((HierarchicalStreamDriver)new CompactDriver()));
    }

    public XStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver) {
        super(charset, xStream, revisionResolver);
    }

    public XStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver, Converter converter) {
        super(charset, xStream, revisionResolver, converter);
    }

    @Override
    protected <T> T doSerialize(Object object, Class<T> expectedFormat, XStream xStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xStream.toXML(object, (Writer)new OutputStreamWriter((OutputStream)baos, this.getCharset()));
        return this.convert(baos.toByteArray(), byte[].class, expectedFormat);
    }

    @Override
    public Object doDeserialize(SerializedObject serializedObject, XStream xStream) {
        if ("org.dom4j.Document".equals(serializedObject.getContentType().getName())) {
            return xStream.unmarshal((HierarchicalStreamReader)new Dom4JReader((org.dom4j.Document)serializedObject.getData()));
        }
        if ("nu.xom.Document".equals(serializedObject.getContentType().getName())) {
            return xStream.unmarshal((HierarchicalStreamReader)new XomReader((Document)serializedObject.getData()));
        }
        InputStream serializedData = this.convert(serializedObject.getData(), serializedObject.getContentType(), InputStream.class);
        return xStream.fromXML((Reader)new InputStreamReader(serializedData, this.getCharset()));
    }

    @Override
    protected void registerConverters(ChainingConverter converter) {
        converter.registerConverter(Dom4JToByteArrayConverter.class);
        converter.registerConverter(InputStreamToDom4jConverter.class);
        converter.registerConverter(XomToStringConverter.class);
        converter.registerConverter(InputStreamToXomConverter.class);
    }
}

