/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedTypeException;
import org.axonframework.serialization.json.ByteArrayToJsonNodeConverter;
import org.axonframework.serialization.json.JsonNodeToByteArrayConverter;
import org.axonframework.serialization.json.MetaDataDeserializer;

public class JacksonSerializer
implements Serializer {
    private final RevisionResolver revisionResolver;
    private final Converter converter;
    private final ObjectMapper objectMapper;
    private final ClassLoader classLoader;

    public JacksonSerializer() {
        this(new AnnotationRevisionResolver(), new ChainingConverter());
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, new AnnotationRevisionResolver(), new ChainingConverter());
    }

    public JacksonSerializer(RevisionResolver revisionResolver, Converter converter) {
        this(new ObjectMapper(), revisionResolver, converter);
    }

    public JacksonSerializer(ObjectMapper objectMapper, RevisionResolver revisionResolver) {
        this(objectMapper, revisionResolver, new ChainingConverter());
    }

    public JacksonSerializer(ObjectMapper objectMapper, RevisionResolver revisionResolver, Converter converter) {
        this(objectMapper, revisionResolver, converter, null);
    }

    public JacksonSerializer(ObjectMapper objectMapper, RevisionResolver revisionResolver, Converter converter, ClassLoader classLoader) {
        this.revisionResolver = revisionResolver;
        this.converter = converter;
        this.objectMapper = objectMapper;
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.objectMapper.registerModule((Module)new SimpleModule("Axon-Jackson Module").addDeserializer(MetaData.class, (JsonDeserializer)new MetaDataDeserializer()));
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (converter instanceof ChainingConverter) {
            this.registerConverters((ChainingConverter)converter);
        }
    }

    protected void registerConverters(ChainingConverter converter) {
        converter.registerConverter(new JsonNodeToByteArrayConverter(this.objectMapper));
        converter.registerConverter(new ByteArrayToJsonNodeConverter(this.objectMapper));
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedRepresentation) {
        try {
            if (String.class.equals(expectedRepresentation)) {
                return new SimpleSerializedObject<String>(this.getWriter().writeValueAsString(object), expectedRepresentation, this.typeForClass(ObjectUtils.nullSafeTypeOf(object)));
            }
            byte[] serializedBytes = this.getWriter().writeValueAsBytes(object);
            T serializedContent = this.converter.convert(serializedBytes, expectedRepresentation);
            return new SimpleSerializedObject<T>(serializedContent, expectedRepresentation, this.typeForClass(ObjectUtils.nullSafeTypeOf(object)));
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Unable to serialize object", e);
        }
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected ObjectWriter getWriter() {
        return this.objectMapper.writer();
    }

    protected ObjectReader getReader(Class<?> type) {
        return this.objectMapper.readerFor(type);
    }

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return JsonNode.class.equals(expectedRepresentation) || String.class.equals(expectedRepresentation) || this.converter.canConvert(byte[].class, expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        try {
            if (JsonNode.class.equals(serializedObject.getContentType())) {
                return (T)this.getReader(this.classForType(serializedObject.getType())).readValue((JsonNode)serializedObject.getData());
            }
            SerializedObject<byte[]> byteSerialized = this.converter.convert(serializedObject, byte[].class);
            return (T)this.getReader(this.classForType(serializedObject.getType())).readValue(byteSerialized.getData());
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing object", e);
        }
    }

    @Override
    public Class classForType(SerializedType type) throws UnknownSerializedTypeException {
        if (SimpleSerializedType.emptyType().equals(type)) {
            return Void.class;
        }
        try {
            return this.classLoader.loadClass(this.resolveClassName(type));
        }
        catch (ClassNotFoundException e) {
            throw new UnknownSerializedTypeException(type, (Throwable)e);
        }
    }

    protected String resolveClassName(SerializedType serializedType) {
        return serializedType.getName();
    }

    @Override
    public SerializedType typeForClass(Class type) {
        if (type == null || Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return SimpleSerializedType.emptyType();
        }
        return new SimpleSerializedType(type.getName(), this.revisionResolver.revisionOf(type));
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    protected RevisionResolver getRevisionResolver() {
        return this.revisionResolver;
    }
}

