/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.MessageSerializer;
import org.axonframework.serialization.SerializationAware;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class SerializedObjectHolder
implements SerializationAware {
    private final Message message;
    private final Object payloadGuard = new Object();
    private final Map<Serializer, SerializedObject> serializedPayload = new HashMap<Serializer, SerializedObject>();
    private final Object metaDataGuard = new Object();
    private final Map<Serializer, SerializedObject> serializedMetaData = new HashMap<Serializer, SerializedObject>();

    public SerializedObjectHolder(Message message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SerializedObject<T> serializePayload(Serializer serializer, Class<T> expectedRepresentation) {
        Object object = this.payloadGuard;
        synchronized (object) {
            SerializedObject existingForm = this.serializedPayload.get(serializer);
            if (existingForm == null) {
                SerializedObject<T> serialized = MessageSerializer.serializePayload(this.message, serializer, expectedRepresentation);
                this.serializedPayload.put(serializer, serialized);
                return serialized;
            }
            return serializer.getConverter().convert(existingForm, expectedRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SerializedObject<T> serializeMetaData(Serializer serializer, Class<T> expectedRepresentation) {
        Object object = this.metaDataGuard;
        synchronized (object) {
            SerializedObject existingForm = this.serializedMetaData.get(serializer);
            if (existingForm == null) {
                SerializedObject<T> serialized = MessageSerializer.serializeMetaData(this.message, serializer, expectedRepresentation);
                this.serializedMetaData.put(serializer, serialized);
                return serialized;
            }
            return serializer.getConverter().convert(existingForm, expectedRepresentation);
        }
    }
}

