/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.axonframework.common.Assert;
import org.axonframework.common.io.IOUtils;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerialVersionUIDRevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedTypeException;

public class JavaSerializer
implements Serializer {
    private final Converter converter = new ChainingConverter();
    private final RevisionResolver revisionResolver;

    public JavaSerializer() {
        this(new SerialVersionUIDRevisionResolver());
    }

    public JavaSerializer(RevisionResolver revisionResolver) {
        Assert.notNull(revisionResolver, () -> "revisionResolver may not be null");
        this.revisionResolver = revisionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SerializedObject<T> serialize(Object instance, Class<T> expectedType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(instance);
            }
            finally {
                oos.flush();
            }
        }
        catch (IOException e) {
            throw new SerializationException("An exception occurred writing serialized data to the output stream", e);
        }
        T converted = this.converter.convert(baos.toByteArray(), expectedType);
        return new SimpleSerializedObject<T>(converted, expectedType, this.getSerializedType(instance));
    }

    private SerializedType getSerializedType(Object instance) {
        SerializedType serializedType = instance == null ? SimpleSerializedType.emptyType() : new SimpleSerializedType(instance.getClass().getName(), this.revisionOf(instance.getClass()));
        return serializedType;
    }

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.converter.canConvert(byte[].class, expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        Object object;
        SerializedObject<InputStream> converted = this.converter.convert(serializedObject, InputStream.class);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(converted.getData());
            object = ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            try {
                throw new SerializationException("An error occurred while deserializing: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ois);
        return (T)object;
    }

    @Override
    public Class classForType(SerializedType type) {
        try {
            return Class.forName(type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnknownSerializedTypeException(type, (Throwable)e);
        }
    }

    @Override
    public SerializedType typeForClass(Class type) {
        return new SimpleSerializedType(type.getName(), this.revisionOf(type));
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    private String revisionOf(Class<?> type) {
        return this.revisionResolver.revisionOf(type);
    }
}

