/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.common.Assert;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.saga.AnnotatedSaga;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.AssociationValues;
import org.axonframework.eventhandling.saga.AssociationValuesImpl;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedTypeException;

public abstract class AbstractXStreamSerializer
implements Serializer {
    private static final Charset DEFAULT_CHARSET_NAME = Charset.forName("UTF-8");
    private final XStream xStream;
    private final Charset charset;
    private final RevisionResolver revisionResolver;
    private final Converter converter;

    protected AbstractXStreamSerializer(XStream xStream) {
        this(xStream, new AnnotationRevisionResolver());
    }

    protected AbstractXStreamSerializer(XStream xStream, RevisionResolver revisionResolver) {
        this(DEFAULT_CHARSET_NAME, xStream, revisionResolver);
    }

    protected AbstractXStreamSerializer(Charset charset, XStream xStream) {
        this(charset, xStream, new AnnotationRevisionResolver(), new ChainingConverter());
    }

    protected AbstractXStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver) {
        this(charset, xStream, revisionResolver, new ChainingConverter());
    }

    protected AbstractXStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver, Converter converter) {
        Assert.notNull(charset, () -> "charset may not be null");
        Assert.notNull(xStream, () -> "xStream may not be null");
        Assert.notNull(converter, () -> "converter may not be null");
        Assert.notNull(revisionResolver, () -> "revisionResolver may not be null");
        this.charset = charset;
        this.xStream = xStream;
        this.converter = converter;
        this.revisionResolver = revisionResolver;
        if (converter instanceof ChainingConverter) {
            this.registerConverters((ChainingConverter)converter);
        }
        xStream.addImmutableType(UUID.class, true);
        xStream.alias("domain-event", GenericDomainEventMessage.class);
        xStream.alias("event", GenericEventMessage.class);
        xStream.alias("command", GenericCommandMessage.class);
        xStream.addDefaultImplementation(AssociationValuesImpl.class, AssociationValues.class);
        xStream.aliasField("associations", AnnotatedSaga.class, "associationValues");
        xStream.alias("association", AssociationValue.class);
        xStream.aliasField("key", AssociationValue.class, "propertyKey");
        xStream.aliasField("value", AssociationValue.class, "propertyValue");
        xStream.alias("uuid", UUID.class);
        xStream.alias("meta-data", MetaData.class);
        xStream.registerConverter((com.thoughtworks.xstream.converters.Converter)new MetaDataConverter(xStream.getMapper()));
    }

    protected abstract void registerConverters(ChainingConverter var1);

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.converter.canConvert(byte[].class, expectedRepresentation);
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedType) {
        T result = this.doSerialize(object, expectedType, this.xStream);
        return new SimpleSerializedObject<T>(result, expectedType, this.typeForClass(ObjectUtils.nullSafeTypeOf(object)));
    }

    protected abstract <T> T doSerialize(Object var1, Class<T> var2, XStream var3);

    protected abstract Object doDeserialize(SerializedObject var1, XStream var2);

    protected <S, T> T convert(S source, Class<S> sourceType, Class<T> targetType) {
        return this.getConverter().convert(source, sourceType, targetType);
    }

    private String revisionOf(Class<?> type) {
        return this.revisionResolver.revisionOf(type);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        return (T)this.doDeserialize(serializedObject, this.xStream);
    }

    @Override
    public Class classForType(SerializedType type) {
        try {
            return this.xStream.getMapper().realClass(type.getName());
        }
        catch (CannotResolveClassException e) {
            throw new UnknownSerializedTypeException(type, (Throwable)e);
        }
    }

    @Override
    public SerializedType typeForClass(Class type) {
        if (type == null || Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return SimpleSerializedType.emptyType();
        }
        return new SimpleSerializedType(this.typeIdentifierOf(type), this.revisionOf(type));
    }

    public void addAlias(String name, Class type) {
        this.xStream.alias(name, type);
    }

    public void addPackageAlias(String alias, String pkgName) {
        this.xStream.aliasPackage(alias, pkgName);
    }

    public void addFieldAlias(String alias, Class definedIn, String fieldName) {
        this.xStream.aliasField(alias, definedIn, fieldName);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    private String typeIdentifierOf(Class<?> type) {
        return this.xStream.getMapper().serializedClass(type);
    }

    private static final class MetaDataConverter
    extends MapConverter {
        public MetaDataConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return MetaData.class.equals((Object)type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            MetaData metaData = (MetaData)source;
            if (!metaData.isEmpty()) {
                super.marshal(new HashMap<String, Object>(metaData), writer, context);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (!reader.hasMoreChildren()) {
                return MetaData.emptyInstance();
            }
            HashMap contents = new HashMap();
            this.populateMap(reader, context, contents);
            if (contents.isEmpty()) {
                return MetaData.emptyInstance();
            }
            return MetaData.from(contents);
        }
    }
}

