/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.responsetypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.axonframework.queryhandling.responsetypes.AbstractResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleInstancesResponseType<R>
extends AbstractResponseType<List<R>> {
    private static final Logger logger = LoggerFactory.getLogger(MultipleInstancesResponseType.class);

    @JsonCreator
    public MultipleInstancesResponseType(@JsonProperty(value="expectedResponseType") Class<R> expectedCollectionGenericType) {
        super(expectedCollectionGenericType);
    }

    @Override
    public boolean matches(Type responseType) {
        Type unwrapped = this.unwrapIfTypeFuture(responseType);
        return this.isIterableOfExpectedType(unwrapped) || this.isStreamOfExpectedType(unwrapped) || this.isGenericArrayOfExpectedType(unwrapped) || this.isArrayOfExpectedType(unwrapped);
    }

    @Override
    public List<R> convert(Object response) {
        Class<?> responseType = response.getClass();
        if (this.isArrayOfExpectedType(responseType)) {
            return Arrays.asList((Object[])response);
        }
        if (this.isIterableOfExpectedType(response)) {
            return this.convertToList((Iterable)response);
        }
        throw new IllegalArgumentException("Retrieved response [" + responseType + "] is not convertible to a List of the expected response type [" + this.expectedResponseType + "]");
    }

    @Override
    public Class responseMessagePayloadType() {
        return List.class;
    }

    private boolean isIterableOfExpectedType(Object response) {
        Class<?> responseType = response.getClass();
        boolean isIterableType = Iterable.class.isAssignableFrom(responseType);
        if (!isIterableType) {
            return false;
        }
        Iterator responseIterator = ((Iterable)response).iterator();
        boolean canMatchContainedType = responseIterator.hasNext();
        if (!canMatchContainedType) {
            logger.info("The given response is an Iterable without any contents, hence we cannot verify if the contained type is assignable to the expected type.");
            return true;
        }
        return this.isAssignableFrom(responseIterator.next().getClass());
    }

    private List<R> convertToList(Iterable responseIterable) {
        ArrayList response = new ArrayList();
        Iterator responseIterator = responseIterable.iterator();
        responseIterator.forEachRemaining(responseInstance -> response.add(responseInstance));
        return response;
    }

    public String toString() {
        return "MultipleInstancesResponseType{" + this.expectedResponseType + "}";
    }
}

