/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotation;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandlerAdapter;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.annotation.QueryHandlingMember;

public class AnnotationQueryHandlerAdapter<T>
implements QueryHandlerAdapter,
MessageHandler<QueryMessage<?, ?>> {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;

    public AnnotationQueryHandlerAdapter(T target) {
        this(target, ClasspathParameterResolverFactory.forClass(target.getClass()));
    }

    public AnnotationQueryHandlerAdapter(T target, ParameterResolverFactory parameterResolverFactory) {
        this(target, parameterResolverFactory, ClasspathHandlerDefinition.forClass(target.getClass()));
    }

    public AnnotationQueryHandlerAdapter(T target, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.model = AnnotatedHandlerInspector.inspectType(target.getClass(), parameterResolverFactory, handlerDefinition);
        this.target = target;
    }

    @Override
    public Registration subscribe(QueryBus queryBus) {
        Collection registrationList = this.model.getHandlers().stream().map(m -> this.subscribe(queryBus, (MessageHandlingMember<? super T>)m)).filter(Objects::nonNull).collect(Collectors.toList());
        return () -> registrationList.stream().map(Registration::cancel).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public Object handle(QueryMessage<?, ?> message) throws Exception {
        for (MessageHandlingMember<T> member : this.model.getHandlers()) {
            if (!member.canHandle(message)) continue;
            return member.handle(message, this.target);
        }
        throw new NoHandlerForQueryException("No suitable handler was found for the query of type " + message.getPayloadType().getName());
    }

    private Registration subscribe(QueryBus queryBus, MessageHandlingMember<? super T> m) {
        Optional<QueryHandlingMember> unwrappedQueryMember = m.unwrap(QueryHandlingMember.class);
        if (unwrappedQueryMember.isPresent()) {
            QueryHandlingMember qhm = unwrappedQueryMember.get();
            return queryBus.subscribe(qhm.getQueryName(), qhm.getResultType(), this);
        }
        return null;
    }
}

