/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.interceptors.TransactionManagingInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.queryhandling.DefaultSubscriptionQueryResult;
import org.axonframework.queryhandling.FluxSinkWrapper;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.MonoWrapper;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryExecutionException;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QuerySubscription;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.responsetypes.ResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.FluxSink;

public class SimpleQueryBus
implements QueryBus,
QueryUpdateEmitter {
    private static final Logger logger = LoggerFactory.getLogger(SimpleQueryBus.class);
    private static final String QUERY_UPDATE_TASKS_RESOURCE_KEY = "/update-tasks";
    private final ConcurrentMap<String, CopyOnWriteArrayList<QuerySubscription>> subscriptions = new ConcurrentHashMap<String, CopyOnWriteArrayList<QuerySubscription>>();
    private final ConcurrentMap<SubscriptionQueryMessage<?, ?, ?>, FluxSinkWrapper<?>> updateHandlers = new ConcurrentHashMap();
    private final MessageMonitor<? super QueryMessage<?, ?>> messageMonitor;
    private final MessageMonitor<? super SubscriptionQueryUpdateMessage<?>> updateMessageMonitor;
    private final QueryInvocationErrorHandler errorHandler;
    private final List<MessageHandlerInterceptor<? super QueryMessage<?, ?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors = new CopyOnWriteArrayList();

    public SimpleQueryBus() {
        this(NoOpMessageMonitor.INSTANCE, NoTransactionManager.instance(), new LoggingQueryInvocationErrorHandler(logger));
    }

    public SimpleQueryBus(TransactionManager transactionManager) {
        this(NoOpMessageMonitor.INSTANCE, transactionManager, new LoggingQueryInvocationErrorHandler(logger));
    }

    public SimpleQueryBus(MessageMonitor<? super QueryMessage<?, ?>> messageMonitor, TransactionManager transactionManager, QueryInvocationErrorHandler errorHandler) {
        this(messageMonitor, NoOpMessageMonitor.INSTANCE, transactionManager, errorHandler);
    }

    public SimpleQueryBus(MessageMonitor<? super QueryMessage<?, ?>> messageMonitor, MessageMonitor<? super SubscriptionQueryUpdateMessage<?>> updateMessageMonitor, TransactionManager transactionManager, QueryInvocationErrorHandler errorHandler) {
        this.messageMonitor = messageMonitor != null ? messageMonitor : NoOpMessageMonitor.instance();
        this.updateMessageMonitor = updateMessageMonitor != null ? updateMessageMonitor : NoOpMessageMonitor.instance();
        this.errorHandler = (QueryInvocationErrorHandler)((Object)ObjectUtils.getOrDefault(errorHandler, () -> new LoggingQueryInvocationErrorHandler(logger)));
        if (transactionManager != null) {
            this.registerHandlerInterceptor(new TransactionManagingInterceptor(transactionManager));
        }
    }

    @Override
    public <R> Registration subscribe(String queryName, Type responseType, MessageHandler<? super QueryMessage<?, R>> handler) {
        CopyOnWriteArrayList handlers = this.subscriptions.computeIfAbsent(queryName, k -> new CopyOnWriteArrayList());
        QuerySubscription querySubscription = new QuerySubscription(responseType, handler);
        handlers.addIfAbsent(querySubscription);
        return () -> this.unsubscribe(queryName, querySubscription);
    }

    private boolean unsubscribe(String queryName, QuerySubscription querySubscription) {
        this.subscriptions.computeIfPresent(queryName, (key, handlers) -> {
            handlers.remove(querySubscription);
            if (handlers.isEmpty()) {
                return null;
            }
            return handlers;
        });
        return true;
    }

    @Override
    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(QueryMessage<Q, R> query) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(query);
        QueryMessage<Q, R> interceptedQuery = this.intercept(query);
        List<MessageHandler<QueryMessage<?, ?>>> handlers = this.getHandlersForMessage(interceptedQuery);
        CompletableFuture<QueryResponseMessage<R>> result = new CompletableFuture<QueryResponseMessage<R>>();
        try {
            if (handlers.isEmpty()) {
                throw new NoHandlerForQueryException(String.format("No handler found for [%s] with response type [%s]", interceptedQuery.getQueryName(), interceptedQuery.getResponseType()));
            }
            Iterator<MessageHandler<QueryMessage<?, ?>>> handlerIterator = handlers.iterator();
            boolean invocationSuccess = false;
            while (!invocationSuccess && handlerIterator.hasNext()) {
                try {
                    DefaultUnitOfWork<QueryMessage<Q, R>> uow = DefaultUnitOfWork.startAndGet(interceptedQuery);
                    result = this.interceptAndInvoke(uow, handlerIterator.next());
                    invocationSuccess = true;
                }
                catch (NoHandlerForQueryException noHandlerForQueryException) {}
            }
            if (!invocationSuccess) {
                throw new NoHandlerForQueryException(String.format("No suitable handler was found for [%s] with response type [%s]", interceptedQuery.getQueryName(), interceptedQuery.getResponseType()));
            }
            monitorCallback.reportSuccess();
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            monitorCallback.reportFailure(e);
        }
        return result;
    }

    @Override
    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(QueryMessage<Q, R> query, long timeout, TimeUnit unit) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(query);
        QueryMessage interceptedQuery = this.intercept(query);
        List<MessageHandler<QueryMessage<?, ?>>> handlers = this.getHandlersForMessage(interceptedQuery);
        if (handlers.isEmpty()) {
            monitorCallback.reportIgnored();
            return Stream.empty();
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        return handlers.stream().map(handler -> {
            try {
                long leftTimeout = ObjectUtils.getRemainingOfDeadline(deadline);
                QueryResponseMessage response = this.interceptAndInvoke(DefaultUnitOfWork.startAndGet(interceptedQuery), (MessageHandler)handler).get(leftTimeout, TimeUnit.MILLISECONDS);
                monitorCallback.reportSuccess();
                return response;
            }
            catch (Exception e) {
                monitorCallback.reportFailure(e);
                this.errorHandler.onError(e, interceptedQuery, (MessageHandler)handler);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Override
    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(SubscriptionQueryMessage<Q, I, U> query, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        boolean alreadyExists = this.updateHandlers.keySet().stream().anyMatch(m -> m.getIdentifier().equals(query.getIdentifier()));
        if (alreadyExists) {
            throw new IllegalArgumentException("There is already a subscription with the given message identifier");
        }
        MonoWrapper initialResult = MonoWrapper.create(monoSink -> ((CompletableFuture)this.query(query).thenAccept(monoSink::success)).exceptionally(t -> {
            logger.error(String.format("An error happened while trying to report an initial result. Query: %s", query), t);
            monoSink.error(t.getCause());
            return null;
        }));
        EmitterProcessor processor = EmitterProcessor.create((int)updateBufferSize);
        FluxSink sink = processor.sink(backpressure.getOverflowStrategy());
        sink.onDispose(() -> {
            FluxSinkWrapper cfr_ignored_0 = (FluxSinkWrapper)this.updateHandlers.remove(query);
        });
        FluxSinkWrapper fluxSinkWrapper = new FluxSinkWrapper(sink);
        this.updateHandlers.put(query, fluxSinkWrapper);
        Registration registration = () -> {
            fluxSinkWrapper.complete();
            return true;
        };
        return new DefaultSubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>>(initialResult.getMono(), processor.replay(updateBufferSize).autoConnect(), registration);
    }

    @Override
    public <U> void emit(Predicate<SubscriptionQueryMessage<?, ?, U>> filter, SubscriptionQueryUpdateMessage<U> update) {
        this.runOnAfterCommitOrNow(() -> this.doEmit(filter, update));
    }

    private <U> void doEmit(Predicate<SubscriptionQueryMessage<?, ?, U>> filter, SubscriptionQueryUpdateMessage<U> update) {
        this.updateHandlers.keySet().stream().filter(sqm -> filter.test((SubscriptionQueryMessage)sqm)).forEach(query -> Optional.ofNullable(this.updateHandlers.get(query)).ifPresent(uh -> this.doEmit((SubscriptionQueryMessage<?, ?, ?>)query, (FluxSinkWrapper<?>)uh, update)));
    }

    @Override
    public void complete(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter) {
        this.runOnAfterCommitOrNow(() -> this.doComplete(filter));
    }

    private void doComplete(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter) {
        this.updateHandlers.keySet().stream().filter(filter).forEach(query -> Optional.ofNullable(this.updateHandlers.get(query)).ifPresent(updateHandler -> {
            try {
                updateHandler.complete();
            }
            catch (Exception e) {
                this.emitError((SubscriptionQueryMessage<?, ?, ?>)query, e, (FluxSinkWrapper<?>)updateHandler);
            }
        }));
    }

    @Override
    public void completeExceptionally(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter, Throwable cause) {
        this.runOnAfterCommitOrNow(() -> this.doCompleteExceptionally(filter, cause));
    }

    private void doCompleteExceptionally(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter, Throwable cause) {
        this.updateHandlers.keySet().stream().filter(filter).forEach(query -> Optional.ofNullable(this.updateHandlers.get(query)).ifPresent(updateHandler -> this.emitError((SubscriptionQueryMessage<?, ?, ?>)query, cause, (FluxSinkWrapper<?>)updateHandler)));
    }

    private void runOnAfterCommitOrNow(Runnable queryUpdateTask) {
        if (this.inStartedPhaseOfUnitOfWork()) {
            UnitOfWork<?> unitOfWork = CurrentUnitOfWork.get();
            unitOfWork.getOrComputeResource(this.toString() + QUERY_UPDATE_TASKS_RESOURCE_KEY, resourceKey -> {
                ArrayList queryUpdateTasks = new ArrayList();
                unitOfWork.afterCommit(uow -> queryUpdateTasks.forEach(Runnable::run));
                return queryUpdateTasks;
            }).add(queryUpdateTask);
        } else {
            queryUpdateTask.run();
        }
    }

    private boolean inStartedPhaseOfUnitOfWork() {
        return CurrentUnitOfWork.isStarted() && UnitOfWork.Phase.STARTED.equals((Object)CurrentUnitOfWork.get().phase());
    }

    public Set<SubscriptionQueryMessage<?, ?, ?>> activeSubscriptions() {
        return Collections.unmodifiableSet(this.updateHandlers.keySet());
    }

    private <U> void doEmit(SubscriptionQueryMessage<?, ?, ?> query, FluxSinkWrapper<?> updateHandler, SubscriptionQueryUpdateMessage<U> update) {
        MessageMonitor.MonitorCallback monitorCallback = this.updateMessageMonitor.onMessageIngested(update);
        try {
            updateHandler.next(update);
            monitorCallback.reportSuccess();
        }
        catch (Exception e) {
            logger.info("An error occurred while trying to emit an update to a query '{}'. The subscription will be cancelled. Exception summary: {}", new Object[]{query.getQueryName(), e.toString(), logger.isDebugEnabled() ? e : ""});
            monitorCallback.reportFailure(e);
            this.updateHandlers.remove(query);
            this.emitError(query, e, updateHandler);
        }
    }

    private void emitError(SubscriptionQueryMessage<?, ?, ?> query, Throwable cause, FluxSinkWrapper<?> updateHandler) {
        try {
            updateHandler.error(cause);
        }
        catch (Exception e) {
            logger.error(String.format("An error happened while trying to inform update handler about the error. Query: %s", query));
        }
    }

    private <Q, R> CompletableFuture<QueryResponseMessage<R>> interceptAndInvoke(UnitOfWork<QueryMessage<Q, R>> uow, MessageHandler<? super QueryMessage<?, R>> handler) throws Exception {
        return uow.executeWithResult(() -> {
            ResponseType responseType = ((QueryMessage)uow.getMessage()).getResponseType();
            Object queryResponse = new DefaultInterceptorChain(uow, this.handlerInterceptors, handler).proceed();
            if (queryResponse instanceof CompletableFuture) {
                return ((CompletableFuture)queryResponse).thenCompose(result -> this.buildCompletableFuture(responseType, result));
            }
            if (queryResponse instanceof Future) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return ((Future)queryResponse).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new QueryExecutionException("Error happened while trying to execute query handler", e);
                    }
                });
            }
            return this.buildCompletableFuture(responseType, queryResponse);
        });
    }

    private <R> CompletableFuture<QueryResponseMessage<R>> buildCompletableFuture(ResponseType<R> responseType, Object queryResponse) {
        return CompletableFuture.completedFuture(GenericQueryResponseMessage.asNullableResponseMessage(responseType.responseMessagePayloadType(), responseType.convert(queryResponse)));
    }

    private <Q, R, T extends QueryMessage<Q, R>> T intercept(T query) {
        Object intercepted = query;
        for (MessageDispatchInterceptor<QueryMessage<?, ?>> interceptor : this.dispatchInterceptors) {
            intercepted = interceptor.handle((QueryMessage<?, ?>)intercepted);
        }
        return intercepted;
    }

    protected Map<String, Collection<QuerySubscription>> getSubscriptions() {
        return Collections.unmodifiableMap(this.subscriptions);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super QueryMessage<?, ?>> interceptor) {
        this.handlerInterceptors.add(interceptor);
        return () -> this.handlerInterceptors.remove(interceptor);
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super QueryMessage<?, ?>> interceptor) {
        this.dispatchInterceptors.add(interceptor);
        return () -> this.dispatchInterceptors.remove(interceptor);
    }

    private <Q, R> List<MessageHandler<? super QueryMessage<?, ?>>> getHandlersForMessage(QueryMessage<Q, R> queryMessage) {
        ResponseType responseType = queryMessage.getResponseType();
        return this.subscriptions.computeIfAbsent(queryMessage.getQueryName(), k -> new CopyOnWriteArrayList()).stream().filter(querySubscription -> responseType.matches(querySubscription.getResponseType())).map(QuerySubscription::getQueryHandler).map(queryHandler -> queryHandler).collect(Collectors.toList());
    }
}

