/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.responsetypes.ResponseType;
import org.axonframework.queryhandling.responsetypes.ResponseTypes;
import reactor.util.concurrent.Queues;

public interface QueryGateway {
    default public <R, Q> CompletableFuture<R> query(Q query, Class<R> responseType) {
        return this.query(query.getClass().getName(), query, responseType);
    }

    default public <R, Q> CompletableFuture<R> query(String queryName, Q query, Class<R> responseType) {
        return this.query(queryName, query, ResponseTypes.instanceOf(responseType));
    }

    default public <R, Q> CompletableFuture<R> query(Q query, ResponseType<R> responseType) {
        return this.query(query.getClass().getName(), query, responseType);
    }

    public <R, Q> CompletableFuture<R> query(String var1, Q var2, ResponseType<R> var3);

    default public <R, Q> Stream<R> scatterGather(Q query, ResponseType<R> responseType, long timeout, TimeUnit timeUnit) {
        return this.scatterGather(query.getClass().getName(), query, responseType, timeout, timeUnit);
    }

    public <R, Q> Stream<R> scatterGather(String var1, Q var2, ResponseType<R> var3, long var4, TimeUnit var6);

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(Q query, Class<I> initialResponseType, Class<U> updateResponseType) {
        return this.subscriptionQuery(query.getClass().getName(), query, initialResponseType, updateResponseType);
    }

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(String queryName, Q query, Class<I> initialResponseType, Class<U> updateResponseType) {
        return this.subscriptionQuery(queryName, query, ResponseTypes.instanceOf(initialResponseType), ResponseTypes.instanceOf(updateResponseType), SubscriptionQueryBackpressure.defaultBackpressure());
    }

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(Q query, ResponseType<I> initialResponseType, ResponseType<U> updateResponseType) {
        return this.subscriptionQuery(query.getClass().getName(), query, initialResponseType, updateResponseType, SubscriptionQueryBackpressure.defaultBackpressure());
    }

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(String queryName, Q query, ResponseType<I> initialResponseType, ResponseType<U> updateResponseType, SubscriptionQueryBackpressure backpressure) {
        return this.subscriptionQuery(queryName, query, initialResponseType, updateResponseType, backpressure, Queues.SMALL_BUFFER_SIZE);
    }

    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(String var1, Q var2, ResponseType<I> var3, ResponseType<U> var4, SubscriptionQueryBackpressure var5, int var6);

    @Deprecated
    default public <R, Q> CompletableFuture<R> send(String queryName, Q query, Class<R> responseType) {
        return this.query(queryName, query, responseType);
    }

    @Deprecated
    default public <R, Q> CompletableFuture<R> send(Q query, Class<R> responseType) {
        return this.query(query.getClass().getName(), query, responseType);
    }

    @Deprecated
    default public <R, Q> Stream<R> send(Q query, Class<R> responseType, long timeout, TimeUnit timeUnit) {
        return this.scatterGather(query, ResponseTypes.instanceOf(responseType), timeout, timeUnit);
    }

    @Deprecated
    default public <R, Q> Stream<R> send(Q query, String queryName, Class<R> resultClass, long timeout, TimeUnit timeUnit) {
        return this.scatterGather(queryName, query, ResponseTypes.instanceOf(resultClass), timeout, timeUnit);
    }
}

