/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.queryhandling.DefaultSubscriptionQueryResult;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.responsetypes.ResponseType;

public class DefaultQueryGateway
implements QueryGateway {
    private final QueryBus queryBus;
    private final MessageDispatchInterceptor<? super QueryMessage<?, ?>>[] dispatchInterceptors;

    @SafeVarargs
    public DefaultQueryGateway(QueryBus queryBus, MessageDispatchInterceptor<? super QueryMessage<?, ?>> ... dispatchInterceptors) {
        this.queryBus = queryBus;
        this.dispatchInterceptors = dispatchInterceptors;
    }

    @Override
    public <R, Q> CompletableFuture<R> query(String queryName, Q query, ResponseType<R> responseType) {
        return this.queryBus.query(this.processInterceptors(new GenericQueryMessage<Q, R>(query, queryName, responseType))).thenApply(Message::getPayload);
    }

    @Override
    public <R, Q> Stream<R> scatterGather(String queryName, Q query, ResponseType<R> responseType, long timeout, TimeUnit timeUnit) {
        GenericQueryMessage<Q, R> queryMessage = new GenericQueryMessage<Q, R>(query, queryName, responseType);
        return this.queryBus.scatterGather(this.processInterceptors(queryMessage), timeout, timeUnit).map(Message::getPayload);
    }

    @Override
    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(String queryName, Q query, ResponseType<I> initialResponseType, ResponseType<U> updateResponseType, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        GenericSubscriptionQueryMessage<Q, I, U> subscriptionQueryMessage = new GenericSubscriptionQueryMessage<Q, I, U>(query, queryName, initialResponseType, updateResponseType);
        SubscriptionQueryResult result = this.queryBus.subscriptionQuery(this.processInterceptors(subscriptionQueryMessage), backpressure, updateBufferSize);
        return new DefaultSubscriptionQueryResult(result.initialResult().filter(initialResult -> Objects.nonNull(initialResult.getPayload())).map(Message::getPayload), result.updates().filter(update -> Objects.nonNull(update.getPayload())).map(Message::getPayload), result);
    }

    private <Q, R, T extends QueryMessage<Q, R>> T processInterceptors(T query) {
        Object intercepted = query;
        for (MessageDispatchInterceptor<QueryMessage<?, ?>> messageDispatchInterceptor : this.dispatchInterceptors) {
            intercepted = messageDispatchInterceptor.handle((QueryMessage<?, ?>)intercepted);
        }
        return intercepted;
    }
}

