/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Objects;
import org.axonframework.messaging.ExecutionException;

public class ExecutionResult {
    private final Object result;

    public ExecutionResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        if (this.isExceptionResult()) {
            if (this.result instanceof RuntimeException) {
                throw (RuntimeException)this.result;
            }
            if (this.result instanceof Error) {
                throw (Error)this.result;
            }
            throw new ExecutionException("Execution of the task gave rise to an exception", (Throwable)this.result);
        }
        return this.result;
    }

    public Throwable getExceptionResult() {
        return this.isExceptionResult() ? (Throwable)this.result : null;
    }

    public boolean isExceptionResult() {
        return this.result instanceof Throwable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionResult that = (ExecutionResult)o;
        return Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.result);
    }

    public String toString() {
        return String.format("ExecutionResult containing [%s]", this.result);
    }
}

