/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.AbstractUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.MessageProcessingContext;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class DefaultUnitOfWork<T extends Message<?>>
extends AbstractUnitOfWork<T> {
    private final MessageProcessingContext<T> processingContext;

    public static <T extends Message<?>> DefaultUnitOfWork<T> startAndGet(T message) {
        DefaultUnitOfWork<T> uow = new DefaultUnitOfWork<T>(message);
        uow.start();
        return uow;
    }

    public DefaultUnitOfWork(T message) {
        this.processingContext = new MessageProcessingContext<T>(message);
    }

    @Override
    public <R> R executeWithResult(Callable<R> task, RollbackConfiguration rollbackConfiguration) throws Exception {
        R result;
        if (this.phase() == UnitOfWork.Phase.NOT_STARTED) {
            this.start();
        }
        Assert.state(this.phase() == UnitOfWork.Phase.STARTED, () -> String.format("The UnitOfWork has an incompatible phase: %s", new Object[]{this.phase()}));
        try {
            result = task.call();
        }
        catch (Error | Exception e) {
            if (rollbackConfiguration.rollBackOn(e)) {
                this.rollback(e);
            } else {
                this.setExecutionResult(new ExecutionResult(e));
                this.commit();
            }
            throw e;
        }
        this.setExecutionResult(new ExecutionResult(result));
        this.commit();
        return result;
    }

    @Override
    protected void setRollbackCause(Throwable cause) {
        this.setExecutionResult(new ExecutionResult(cause));
    }

    @Override
    protected void notifyHandlers(UnitOfWork.Phase phase) {
        this.processingContext.notifyHandlers(this, phase);
    }

    @Override
    protected void addHandler(UnitOfWork.Phase phase, Consumer<UnitOfWork<T>> handler) {
        Assert.state(!phase.isBefore(this.phase()), () -> "Cannot register a listener for phase: " + (Object)((Object)phase) + " because the Unit of Work is already in a later phase: " + (Object)((Object)this.phase()));
        this.processingContext.addHandler(phase, handler);
    }

    @Override
    public T getMessage() {
        return this.processingContext.getMessage();
    }

    @Override
    public UnitOfWork<T> transformMessage(Function<T, ? extends Message<?>> transformOperator) {
        this.processingContext.transformMessage(transformOperator);
        return this;
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.processingContext.getExecutionResult();
    }

    @Override
    protected void setExecutionResult(ExecutionResult executionResult) {
        this.processingContext.setExecutionResult(executionResult);
    }
}

