/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.AbstractUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.MessageProcessingContext;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class BatchingUnitOfWork<T extends Message<?>>
extends AbstractUnitOfWork<T> {
    private final List<MessageProcessingContext<T>> processingContexts;
    private MessageProcessingContext<T> processingContext;

    @SafeVarargs
    public BatchingUnitOfWork(T ... messages) {
        this(Arrays.asList(messages));
    }

    public BatchingUnitOfWork(List<T> messages) {
        Assert.isFalse(messages.isEmpty(), () -> "The list of Messages to process is empty");
        this.processingContexts = messages.stream().map(MessageProcessingContext::new).collect(Collectors.toList());
        this.processingContext = this.processingContexts.get(0);
    }

    @Override
    public <R> R executeWithResult(Callable<R> task, RollbackConfiguration rollbackConfiguration) throws Exception {
        if (this.phase() == UnitOfWork.Phase.NOT_STARTED) {
            this.start();
        }
        Assert.state(this.phase() == UnitOfWork.Phase.STARTED, () -> String.format("The UnitOfWork has an incompatible phase: %s", new Object[]{this.phase()}));
        R result = null;
        Exception exception = null;
        for (MessageProcessingContext<T> processingContext : this.processingContexts) {
            this.processingContext = processingContext;
            try {
                result = task.call();
            }
            catch (Exception e) {
                if (rollbackConfiguration.rollBackOn(e)) {
                    this.rollback(e);
                    throw e;
                }
                this.setExecutionResult(new ExecutionResult(e));
                if (exception != null) {
                    exception.addSuppressed(e);
                    continue;
                }
                exception = e;
                continue;
            }
            this.setExecutionResult(new ExecutionResult(result));
        }
        this.commit();
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    public Map<Message<?>, ExecutionResult> getExecutionResults() {
        return this.processingContexts.stream().collect(Collectors.toMap(MessageProcessingContext::getMessage, MessageProcessingContext::getExecutionResult));
    }

    @Override
    public T getMessage() {
        return this.processingContext.getMessage();
    }

    @Override
    public UnitOfWork<T> transformMessage(Function<T, ? extends Message<?>> transformOperator) {
        this.processingContext.transformMessage(transformOperator);
        return this;
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.processingContext.getExecutionResult();
    }

    @Override
    protected void setExecutionResult(ExecutionResult executionResult) {
        this.processingContext.setExecutionResult(executionResult);
    }

    @Override
    protected void notifyHandlers(UnitOfWork.Phase phase) {
        Iterator<MessageProcessingContext<T>> iterator = phase.isReverseCallbackOrder() ? new LinkedList<MessageProcessingContext<T>>(this.processingContexts).descendingIterator() : this.processingContexts.iterator();
        iterator.forEachRemaining(context -> {
            this.processingContext = context;
            this.processingContext.notifyHandlers(this, phase);
        });
    }

    @Override
    protected void setRollbackCause(Throwable cause) {
        this.processingContexts.forEach(context -> context.setExecutionResult(new ExecutionResult(cause)));
    }

    @Override
    protected void addHandler(UnitOfWork.Phase phase, Consumer<UnitOfWork<T>> handler) {
        this.processingContext.addHandler(phase, handler);
    }

    public List<? extends Message<?>> getMessages() {
        return this.processingContexts.stream().map(MessageProcessingContext::getMessage).collect(Collectors.toList());
    }

    public boolean isLastMessage(Message<?> message) {
        return this.processingContexts.get(this.processingContexts.size() - 1).getMessage().equals(message);
    }

    public boolean isLastMessage() {
        return this.isLastMessage((Message<?>)this.getMessage());
    }

    public boolean isFirstMessage(Message<?> message) {
        return this.processingContexts.get(0).getMessage().equals(message);
    }

    public boolean isFirstMessage() {
        return this.isFirstMessage((Message<?>)this.getMessage());
    }
}

