/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.StreamUtils;

public interface MessageStream<M extends Message<?>>
extends AutoCloseable {
    default public boolean hasNextAvailable() {
        try {
            return this.hasNextAvailable(0, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public Optional<M> peek();

    public boolean hasNextAvailable(int var1, TimeUnit var2) throws InterruptedException;

    public M nextAvailable() throws InterruptedException;

    @Override
    public void close();

    default public Stream<M> asStream() {
        return StreamUtils.asStream(this);
    }
}

