/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.sql.DataSource;
import org.axonframework.common.Assert;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.eventsourcing.eventstore.GapAwareTrackingToken;
import org.axonframework.eventsourcing.eventstore.GenericDomainEventEntry;
import org.axonframework.eventsourcing.eventstore.TrackedDomainEventData;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.eventsourcing.eventstore.jpa.DomainEventEntry;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jpa.SnapshotEventEntry;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaEventStorageEngine
extends BatchingEventStorageEngine {
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private static final Logger logger = LoggerFactory.getLogger(JpaEventStorageEngine.class);
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private final EntityManagerProvider entityManagerProvider;
    private final long lowestGlobalSequence;
    private final int maxGapOffset;
    private final TransactionManager transactionManager;
    private final boolean explicitFlush;
    private int gapTimeout = 60000;
    private int gapCleaningThreshold = 250;

    public JpaEventStorageEngine(EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        this(null, null, null, null, null, entityManagerProvider, transactionManager, null, null, true);
    }

    public JpaEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, DataSource dataSource, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) throws SQLException {
        this(serializer, upcasterChain, dataSource, serializer, entityManagerProvider, transactionManager);
    }

    public JpaEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, DataSource dataSource, Serializer eventSerializer, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) throws SQLException {
        this(snapshotSerializer, upcasterChain, (PersistenceExceptionResolver)new SQLErrorCodesResolver(dataSource), eventSerializer, entityManagerProvider, transactionManager);
    }

    public JpaEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        this(serializer, upcasterChain, persistenceExceptionResolver, serializer, entityManagerProvider, transactionManager);
    }

    public JpaEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        this(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, null, entityManagerProvider, transactionManager, null, null, true);
    }

    public JpaEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Integer batchSize, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager, Long lowestGlobalSequence, Integer maxGapOffset, boolean explicitFlush) {
        super(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, batchSize);
        this.entityManagerProvider = entityManagerProvider;
        this.lowestGlobalSequence = ObjectUtils.getOrDefault(lowestGlobalSequence, 1L);
        this.maxGapOffset = ObjectUtils.getOrDefault(maxGapOffset, 10000);
        this.transactionManager = transactionManager;
        this.explicitFlush = explicitFlush;
    }

    @Override
    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        Assert.isTrue(lastToken == null || lastToken instanceof GapAwareTrackingToken, () -> String.format("Token [%s] is of the wrong type. Expected [%s]", lastToken, GapAwareTrackingToken.class.getSimpleName()));
        GapAwareTrackingToken previousToken = this.cleanedToken((GapAwareTrackingToken)lastToken);
        List entries = this.transactionManager.fetchInTransaction(() -> {
            TypedQuery query = previousToken == null || previousToken.getGaps().isEmpty() ? this.entityManager().createQuery("SELECT e.globalIndex, e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex > :token ORDER BY e.globalIndex ASC", Object[].class) : this.entityManager().createQuery("SELECT e.globalIndex, e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex > :token OR e.globalIndex IN :gaps ORDER BY e.globalIndex ASC", Object[].class).setParameter("gaps", previousToken.getGaps());
            return query.setParameter("token", (Object)(previousToken == null ? -1L : previousToken.getIndex())).setMaxResults(batchSize).getResultList();
        });
        ArrayList<TrackedDomainEventData<Object>> result = new ArrayList<TrackedDomainEventData<Object>>();
        GapAwareTrackingToken token = previousToken;
        for (Object[] entry : entries) {
            long globalSequence = (Long)entry[0];
            GenericDomainEventEntry<Object> domainEvent = new GenericDomainEventEntry<Object>((String)entry[1], (String)entry[2], (Long)entry[3], (String)entry[4], entry[5], (String)entry[6], (String)entry[7], entry[8], entry[9]);
            boolean allowGaps = domainEvent.getTimestamp().isAfter(this.gapTimeoutFrame());
            token = token == null ? GapAwareTrackingToken.newInstance(globalSequence, allowGaps ? (Collection)LongStream.range(Math.min(this.lowestGlobalSequence, globalSequence), globalSequence).boxed().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet()) : token.advanceTo(globalSequence, this.maxGapOffset, allowGaps);
            result.add(new TrackedDomainEventData<Object>(token, domainEvent));
        }
        return result;
    }

    private GapAwareTrackingToken cleanedToken(GapAwareTrackingToken lastToken) {
        GapAwareTrackingToken previousToken = lastToken;
        if (lastToken != null && lastToken.getGaps().size() > this.gapCleaningThreshold) {
            List results = this.transactionManager.fetchInTransaction(() -> this.entityManager().createQuery("SELECT e.globalIndex, e.timeStamp FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex >= :firstGapOffset AND e.globalIndex <= :maxGlobalIndex", Object[].class).setParameter("firstGapOffset", (Object)lastToken.getGaps().first()).setParameter("maxGlobalIndex", (Object)(lastToken.getGaps().last() + 1L)).getResultList());
            for (Object[] result : results) {
                try {
                    Instant timestamp = DateTimeUtils.parseInstant(result[1].toString());
                    long sequenceNumber = (Long)result[0];
                    if (previousToken.getGaps().contains(sequenceNumber) || timestamp.isAfter(this.gapTimeoutFrame())) break;
                    if (!previousToken.getGaps().contains(sequenceNumber - 1L)) continue;
                    previousToken = previousToken.advanceTo(sequenceNumber - 1L, this.maxGapOffset, false);
                }
                catch (DateTimeParseException e) {
                    logger.info("Unable to parse timestamp to clean old gaps", (Throwable)e);
                    break;
                }
            }
        }
        return previousToken;
    }

    private Instant gapTimeoutFrame() {
        return GenericEventMessage.clock.instant().minus(this.gapTimeout, ChronoUnit.MILLIS);
    }

    @Override
    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return this.transactionManager.fetchInTransaction(() -> this.entityManager().createQuery("SELECT new org.axonframework.eventsourcing.eventstore.GenericDomainEventEntry(e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.domainEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :id AND e.sequenceNumber >= :seq ORDER BY e.sequenceNumber ASC").setParameter("id", (Object)aggregateIdentifier).setParameter("seq", (Object)firstSequenceNumber).setMaxResults(batchSize).getResultList());
    }

    @Override
    protected Optional<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return this.transactionManager.fetchInTransaction(() -> this.entityManager().createQuery("SELECT new org.axonframework.eventsourcing.eventstore.GenericDomainEventEntry(e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.snapshotEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :id ORDER BY e.sequenceNumber DESC").setParameter("id", (Object)aggregateIdentifier).setMaxResults(1).getResultList().stream().findFirst());
    }

    @Override
    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (events.isEmpty()) {
            return;
        }
        try {
            events.stream().map(event -> this.createEventEntity((EventMessage<?>)event, serializer)).forEach(arg_0 -> ((EntityManager)this.entityManager()).persist(arg_0));
            if (this.explicitFlush) {
                this.entityManager().flush();
            }
        }
        catch (Exception e) {
            this.handlePersistenceException(e, events.get(0));
        }
    }

    @Override
    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        try {
            this.entityManager().merge(this.createSnapshotEntity(snapshot, serializer));
            this.deleteSnapshots(snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber());
            if (this.explicitFlush) {
                this.entityManager().flush();
            }
        }
        catch (Exception e) {
            this.handlePersistenceException(e, snapshot);
        }
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        List results = this.entityManager().createQuery("SELECT MAX(e.sequenceNumber) FROM " + this.domainEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :aggregateId", Long.class).setParameter("aggregateId", (Object)aggregateIdentifier).getResultList();
        if (results.size() == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(results.get(0));
    }

    @Override
    public TrackingToken createTailToken() {
        List results = this.entityManager().createQuery("SELECT MIN(e.globalIndex) - 1 FROM " + this.domainEventEntryEntityName() + " e", Long.class).getResultList();
        return this.createToken(results);
    }

    @Override
    public TrackingToken createHeadToken() {
        List results = this.entityManager().createQuery("SELECT MAX(e.globalIndex) FROM " + this.domainEventEntryEntityName() + " e", Long.class).getResultList();
        return this.createToken(results);
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        List results = this.entityManager().createQuery("SELECT MIN(e.globalIndex) - 1 FROM " + this.domainEventEntryEntityName() + " e WHERE e.timeStamp >= :dateTime", Long.class).setParameter("dateTime", (Object)DateTimeUtils.formatInstant(dateTime)).getResultList();
        return this.createToken(results);
    }

    private TrackingToken createToken(List<Long> results) {
        if (results.size() == 0 || results.get(0) == null) {
            return null;
        }
        return GapAwareTrackingToken.newInstance(results.get(0), Collections.emptySet());
    }

    protected void deleteSnapshots(String aggregateIdentifier, long sequenceNumber) {
        this.entityManager().createQuery("DELETE FROM " + this.snapshotEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :aggregateIdentifier AND e.sequenceNumber < :sequenceNumber").setParameter("aggregateIdentifier", (Object)aggregateIdentifier).setParameter("sequenceNumber", (Object)sequenceNumber).executeUpdate();
    }

    protected Object createEventEntity(EventMessage<?> eventMessage, Serializer serializer) {
        return new DomainEventEntry(EventUtils.asDomainEventMessage(eventMessage), serializer);
    }

    protected Object createSnapshotEntity(DomainEventMessage<?> snapshot, Serializer serializer) {
        return new SnapshotEventEntry(snapshot, serializer);
    }

    protected String domainEventEntryEntityName() {
        return DomainEventEntry.class.getSimpleName();
    }

    protected String snapshotEventEntryEntityName() {
        return SnapshotEventEntry.class.getSimpleName();
    }

    protected EntityManager entityManager() {
        return this.entityManagerProvider.getEntityManager();
    }

    public void setGapTimeout(int gapTimeout) {
        this.gapTimeout = gapTimeout;
    }

    public void setGapCleaningThreshold(int gapCleaningThreshold) {
        this.gapCleaningThreshold = gapCleaningThreshold;
    }
}

