/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.axonframework.commandhandling.model.ConcurrencyException;
import org.axonframework.common.Assert;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.eventsourcing.eventstore.GapAwareTrackingToken;
import org.axonframework.eventsourcing.eventstore.GenericDomainEventEntry;
import org.axonframework.eventsourcing.eventstore.TrackedDomainEventData;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;
import org.axonframework.eventsourcing.eventstore.jdbc.EventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcSQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.serialization.MessageSerializer;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcEventStorageEngine
extends BatchingEventStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(JpaEventStorageEngine.class);
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private final ConnectionProvider connectionProvider;
    private final TransactionManager transactionManager;
    private final Class<?> dataType;
    private final EventSchema schema;
    private final int maxGapOffset;
    private final long lowestGlobalSequence;
    private int gapTimeout = 60000;
    private int gapCleaningThreshold = 250;

    public JdbcEventStorageEngine(ConnectionProvider connectionProvider, TransactionManager transactionManager) {
        this(null, null, null, null, null, connectionProvider, transactionManager, byte[].class, new EventSchema(), null, null);
    }

    public JdbcEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, ConnectionProvider connectionProvider, TransactionManager transactionManager) {
        this(serializer, upcasterChain, persistenceExceptionResolver, serializer, connectionProvider, transactionManager);
    }

    public JdbcEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, ConnectionProvider connectionProvider, TransactionManager transactionManager) {
        this(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, null, connectionProvider, transactionManager, byte[].class, new EventSchema(), null, null);
    }

    public JdbcEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Integer batchSize, ConnectionProvider connectionProvider, TransactionManager transactionManager, Class<?> dataType, EventSchema schema, Integer maxGapOffset, Long lowestGlobalSequence) {
        this(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, null, batchSize, connectionProvider, transactionManager, dataType, schema, maxGapOffset, lowestGlobalSequence);
    }

    public JdbcEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Predicate<? super DomainEventData<?>> snapshotFilter, Integer batchSize, ConnectionProvider connectionProvider, TransactionManager transactionManager, Class<?> dataType, EventSchema schema, Integer maxGapOffset, Long lowestGlobalSequence) {
        super(snapshotSerializer, upcasterChain, ObjectUtils.getOrDefault(persistenceExceptionResolver, new JdbcSQLErrorCodesResolver()), eventSerializer, snapshotFilter, batchSize);
        this.connectionProvider = connectionProvider;
        this.transactionManager = transactionManager;
        this.dataType = dataType;
        this.schema = schema;
        this.lowestGlobalSequence = ObjectUtils.getOrDefault(lowestGlobalSequence, 1L);
        this.maxGapOffset = ObjectUtils.getOrDefault(maxGapOffset, 10000);
    }

    public void createSchema(EventTableFactory schemaFactory) {
        JdbcUtils.executeUpdates(this.getConnection(), e -> {
            throw new EventStoreException("Failed to create event tables", (Throwable)e);
        }, connection -> schemaFactory.createDomainEventTable(connection, this.schema), connection -> schemaFactory.createSnapshotEventTable(connection, this.schema));
    }

    @Override
    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (events.isEmpty()) {
            return;
        }
        String table = this.schema.domainEventTable();
        String sql = "INSERT INTO " + table + " (" + String.join((CharSequence)", ", this.schema.eventIdentifierColumn(), this.schema.aggregateIdentifierColumn(), this.schema.sequenceNumberColumn(), this.schema.typeColumn(), this.schema.timestampColumn(), this.schema.payloadTypeColumn(), this.schema.payloadRevisionColumn(), this.schema.payloadColumn(), this.schema.metaDataColumn()) + ") VALUES (?,?,?,?,?,?,?,?,?)";
        this.transactionManager.executeInTransaction(() -> JdbcUtils.executeBatch(this.getConnection(), connection -> {
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            for (EventMessage eventMessage : events) {
                DomainEventMessage event = EventUtils.asDomainEventMessage(eventMessage);
                SerializedObject<?> payload = MessageSerializer.serializePayload(event, serializer, this.dataType);
                SerializedObject<?> metaData = MessageSerializer.serializeMetaData(event, serializer, this.dataType);
                preparedStatement.setString(1, event.getIdentifier());
                preparedStatement.setString(2, event.getAggregateIdentifier());
                preparedStatement.setLong(3, event.getSequenceNumber());
                preparedStatement.setString(4, event.getType());
                this.writeTimestamp(preparedStatement, 5, event.getTimestamp());
                preparedStatement.setString(6, payload.getType().getName());
                preparedStatement.setString(7, payload.getType().getRevision());
                preparedStatement.setObject(8, payload.getData());
                preparedStatement.setObject(9, metaData.getData());
                preparedStatement.addBatch();
            }
            return preparedStatement;
        }, e -> this.handlePersistenceException((Exception)e, (EventMessage)events.get(0))));
    }

    @Override
    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        this.transactionManager.executeInTransaction(() -> {
            try {
                JdbcUtils.executeUpdates(this.getConnection(), e -> this.handlePersistenceException((Exception)e, snapshot), connection -> this.appendSnapshot(connection, snapshot, serializer), connection -> this.deleteSnapshots(connection, snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber()));
            }
            catch (ConcurrencyException concurrencyException) {
                // empty catch block
            }
        });
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        String sql = "SELECT max(" + this.schema.sequenceNumberColumn() + ") FROM " + this.schema.domainEventTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ?";
        return Optional.ofNullable(this.transactionManager.fetchInTransaction(() -> JdbcUtils.executeQuery(this.getConnection(), connection -> {
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, aggregateIdentifier);
            return stmt;
        }, resultSet -> JdbcUtils.nextAndExtract(resultSet, 1, Long.class), e -> new EventStoreException(String.format("Failed to read events for aggregate [%s]", aggregateIdentifier), (Throwable)e))));
    }

    @Override
    public TrackingToken createTailToken() {
        String sql = "SELECT min(" + this.schema.globalIndexColumn() + ") - 1 FROM " + this.schema.domainEventTable();
        Long index = this.transactionManager.fetchInTransaction(() -> JdbcUtils.executeQuery(this.getConnection(), connection -> connection.prepareStatement(sql), resultSet -> JdbcUtils.nextAndExtract(resultSet, 1, Long.class), e -> new EventStoreException("Failed to get tail token", (Throwable)e)));
        return Optional.ofNullable(index).map(seq -> GapAwareTrackingToken.newInstance(seq, Collections.emptySet())).orElse(null);
    }

    @Override
    public TrackingToken createHeadToken() {
        String sql = "SELECT max(" + this.schema.globalIndexColumn() + ") FROM " + this.schema.domainEventTable();
        Long index = this.transactionManager.fetchInTransaction(() -> JdbcUtils.executeQuery(this.getConnection(), connection -> connection.prepareStatement(sql), resultSet -> JdbcUtils.nextAndExtract(resultSet, 1, Long.class), e -> new EventStoreException("Failed to get head token", (Throwable)e)));
        return Optional.ofNullable(index).map(seq -> GapAwareTrackingToken.newInstance(seq, Collections.emptySet())).orElse(null);
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        String sql = "SELECT min(" + this.schema.globalIndexColumn() + ") - 1 FROM " + this.schema.domainEventTable() + " WHERE " + this.schema.timestampColumn() + " >= ?";
        Long index = this.transactionManager.fetchInTransaction(() -> JdbcUtils.executeQuery(this.getConnection(), connection -> {
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, DateTimeUtils.formatInstant(dateTime));
            return stmt;
        }, resultSet -> JdbcUtils.nextAndExtract(resultSet, 1, Long.class), e -> new EventStoreException(String.format("Failed to get token at [%s]", dateTime), (Throwable)e)));
        if (index == null) {
            return null;
        }
        return GapAwareTrackingToken.newInstance(index, Collections.emptySet());
    }

    protected PreparedStatement appendSnapshot(Connection connection, DomainEventMessage<?> snapshot, Serializer serializer) throws SQLException {
        SerializedObject<?> payload = MessageSerializer.serializePayload(snapshot, serializer, this.dataType);
        SerializedObject<?> metaData = MessageSerializer.serializeMetaData(snapshot, serializer, this.dataType);
        String sql = "INSERT INTO " + this.schema.snapshotTable() + " (" + String.join((CharSequence)", ", this.schema.eventIdentifierColumn(), this.schema.aggregateIdentifierColumn(), this.schema.sequenceNumberColumn(), this.schema.typeColumn(), this.schema.timestampColumn(), this.schema.payloadTypeColumn(), this.schema.payloadRevisionColumn(), this.schema.payloadColumn(), this.schema.metaDataColumn()) + ") VALUES (?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, snapshot.getIdentifier());
        preparedStatement.setString(2, snapshot.getAggregateIdentifier());
        preparedStatement.setLong(3, snapshot.getSequenceNumber());
        preparedStatement.setString(4, snapshot.getType());
        this.writeTimestamp(preparedStatement, 5, snapshot.getTimestamp());
        preparedStatement.setString(6, payload.getType().getName());
        preparedStatement.setString(7, payload.getType().getRevision());
        preparedStatement.setObject(8, payload.getData());
        preparedStatement.setObject(9, metaData.getData());
        return preparedStatement;
    }

    protected PreparedStatement deleteSnapshots(Connection connection, String aggregateIdentifier, long sequenceNumber) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.schema.snapshotTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ? AND " + this.schema.sequenceNumberColumn() + " < ?");
        preparedStatement.setString(1, aggregateIdentifier);
        preparedStatement.setLong(2, sequenceNumber);
        return preparedStatement;
    }

    @Override
    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return this.transactionManager.fetchInTransaction(() -> JdbcUtils.executeQuery(this.getConnection(), connection -> this.readEventData(connection, aggregateIdentifier, firstSequenceNumber, batchSize), JdbcUtils.listResults(this::getDomainEventData), e -> new EventStoreException(String.format("Failed to read events for aggregate [%s]", aggregateIdentifier), (Throwable)e)));
    }

    @Override
    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        Assert.isTrue(lastToken == null || lastToken instanceof GapAwareTrackingToken, () -> "Unsupported token format: " + lastToken);
        return this.transactionManager.fetchInTransaction(() -> {
            GapAwareTrackingToken cleanedToken = lastToken != null && ((GapAwareTrackingToken)lastToken).getGaps().size() > this.gapCleaningThreshold ? this.cleanGaps(lastToken) : (GapAwareTrackingToken)lastToken;
            return JdbcUtils.executeQuery(this.getConnection(), connection -> this.readEventData(connection, cleanedToken, batchSize), resultSet -> {
                GapAwareTrackingToken previousToken = cleanedToken;
                ArrayList results = new ArrayList();
                while (resultSet.next()) {
                    TrackedEventData<?> next = this.getTrackedEventData(resultSet, previousToken);
                    results.add(next);
                    previousToken = (GapAwareTrackingToken)next.trackingToken();
                }
                return results;
            }, e -> new EventStoreException(String.format("Failed to read events from token [%s]", lastToken), (Throwable)e));
        });
    }

    private GapAwareTrackingToken cleanGaps(TrackingToken lastToken) {
        SortedSet<Long> gaps = ((GapAwareTrackingToken)lastToken).getGaps();
        return JdbcUtils.executeQuery(this.getConnection(), conn -> {
            PreparedStatement statement = conn.prepareStatement(String.format("SELECT %s, %s FROM %s WHERE %s >= ? AND %s <= ?", this.schema.globalIndexColumn(), this.schema.timestampColumn(), this.schema.domainEventTable(), this.schema.globalIndexColumn(), this.schema.globalIndexColumn()));
            statement.setLong(1, (Long)gaps.first());
            statement.setLong(2, (Long)gaps.last() + 1L);
            return statement;
        }, resultSet -> {
            GapAwareTrackingToken cleanToken = (GapAwareTrackingToken)lastToken;
            while (resultSet.next()) {
                try {
                    long sequenceNumber = resultSet.getLong(this.schema.globalIndexColumn());
                    Instant timestamp = DateTimeUtils.parseInstant(this.readTimeStamp(resultSet, this.schema.timestampColumn()).toString());
                    if (gaps.contains(sequenceNumber) || timestamp.isAfter(this.gapTimeoutFrame())) break;
                    if (!gaps.contains(sequenceNumber - 1L)) continue;
                    cleanToken = cleanToken.advanceTo(sequenceNumber - 1L, this.maxGapOffset, false);
                }
                catch (DateTimeParseException e) {
                    logger.info("Unable to parse timestamp to clean old gaps. Tokens may contain large numbers of gaps, decreasing Tracking performance.");
                    break;
                }
            }
            return cleanToken;
        }, e -> new EventStoreException(String.format("Failed to read events from token [%s]", lastToken), (Throwable)e));
    }

    @Override
    protected Optional<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return this.transactionManager.fetchInTransaction(() -> {
            List<DomainEventData> result = JdbcUtils.executeQuery(this.getConnection(), connection -> this.readSnapshotData(connection, aggregateIdentifier), JdbcUtils.listResults(this::getSnapshotData), e -> new EventStoreException(String.format("Error reading aggregate snapshot [%s]", aggregateIdentifier), (Throwable)e));
            return result.stream().findFirst();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement readEventData(Connection connection, String identifier, long firstSequenceNumber, int batchSize) throws SQLException {
        Transaction tx = this.transactionManager.startTransaction();
        try {
            String sql = "SELECT " + this.trackedEventFields() + " FROM " + this.schema.domainEventTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ? AND " + this.schema.sequenceNumberColumn() + " >= ? AND " + this.schema.sequenceNumberColumn() + " < ? ORDER BY " + this.schema.sequenceNumberColumn() + " ASC";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, identifier);
            preparedStatement.setLong(2, firstSequenceNumber);
            preparedStatement.setLong(3, firstSequenceNumber + (long)batchSize);
            PreparedStatement preparedStatement2 = preparedStatement;
            return preparedStatement2;
        }
        finally {
            tx.commit();
        }
    }

    protected PreparedStatement readEventData(Connection connection, TrackingToken lastToken, int batchSize) throws SQLException {
        List gaps;
        Assert.isTrue(lastToken == null || lastToken instanceof GapAwareTrackingToken, () -> String.format("Token [%s] is of the wrong type", lastToken));
        GapAwareTrackingToken previousToken = (GapAwareTrackingToken)lastToken;
        String sql = "SELECT " + this.trackedEventFields() + " FROM " + this.schema.domainEventTable() + " WHERE (" + this.schema.globalIndexColumn() + " > ? AND " + this.schema.globalIndexColumn() + " <= ?) ";
        if (previousToken != null) {
            gaps = new ArrayList<Long>(previousToken.getGaps());
            if (!gaps.isEmpty()) {
                sql = sql + " OR " + this.schema.globalIndexColumn() + " IN (" + String.join((CharSequence)",", Collections.nCopies(gaps.size(), "?")) + ") ";
            }
        } else {
            gaps = Collections.emptyList();
        }
        sql = sql + "ORDER BY " + this.schema.globalIndexColumn() + " ASC";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        long globalIndex = previousToken == null ? -1L : previousToken.getIndex();
        preparedStatement.setLong(1, globalIndex);
        preparedStatement.setLong(2, globalIndex + (long)batchSize);
        for (int i = 0; i < gaps.size(); ++i) {
            preparedStatement.setLong(i + 3, (Long)gaps.get(i));
        }
        return preparedStatement;
    }

    protected PreparedStatement readSnapshotData(Connection connection, String identifier) throws SQLException {
        String s = "SELECT " + this.domainEventFields() + " FROM " + this.schema.snapshotTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ? ORDER BY " + this.schema.sequenceNumberColumn() + " DESC";
        PreparedStatement statement = connection.prepareStatement(s);
        statement.setString(1, identifier);
        return statement;
    }

    protected TrackedEventData<?> getTrackedEventData(ResultSet resultSet, GapAwareTrackingToken previousToken) throws SQLException {
        long globalSequence = resultSet.getLong(this.schema.globalIndexColumn());
        GenericDomainEventEntry domainEvent = new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
        boolean allowGaps = domainEvent.getTimestamp().isAfter(this.gapTimeoutFrame());
        GapAwareTrackingToken token = previousToken;
        token = token == null ? GapAwareTrackingToken.newInstance(globalSequence, allowGaps ? (Collection)LongStream.range(Math.min(this.lowestGlobalSequence, globalSequence), globalSequence).boxed().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet()) : token.advanceTo(globalSequence, this.maxGapOffset, allowGaps);
        return new TrackedDomainEventData(token, domainEvent);
    }

    private Instant gapTimeoutFrame() {
        return GenericEventMessage.clock.instant().minus(this.gapTimeout, ChronoUnit.MILLIS);
    }

    protected DomainEventData<?> getDomainEventData(ResultSet resultSet) throws SQLException {
        return new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
    }

    protected DomainEventData<?> getSnapshotData(ResultSet resultSet) throws SQLException {
        return new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
    }

    protected Object readTimeStamp(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getString(columnName);
    }

    protected void writeTimestamp(PreparedStatement preparedStatement, int position, Instant timestamp) throws SQLException {
        preparedStatement.setString(position, DateTimeUtils.formatInstant(timestamp));
    }

    protected <T> T readPayload(ResultSet resultSet, String columnName) throws SQLException {
        if (byte[].class.equals(this.dataType)) {
            return (T)resultSet.getBytes(columnName);
        }
        return (T)resultSet.getObject(columnName);
    }

    protected String domainEventFields() {
        return String.join((CharSequence)", ", this.schema.eventIdentifierColumn(), this.schema.timestampColumn(), this.schema.payloadTypeColumn(), this.schema.payloadRevisionColumn(), this.schema.payloadColumn(), this.schema.metaDataColumn(), this.schema.typeColumn(), this.schema.aggregateIdentifierColumn(), this.schema.sequenceNumberColumn());
    }

    protected String trackedEventFields() {
        return this.schema.globalIndexColumn() + ", " + this.domainEventFields();
    }

    protected EventSchema schema() {
        return this.schema;
    }

    protected Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new EventStoreException("Failed to obtain a database connection", e);
        }
    }

    public void setGapTimeout(int gapTimeout) {
        this.gapTimeout = gapTimeout;
    }

    public void setGapCleaningThreshold(int gapCleaningThreshold) {
        this.gapCleaningThreshold = gapCleaningThreshold;
    }
}

