/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

public class EventSchema {
    private final String domainEventTable;
    private final String snapshotTable;
    private final String globalIndexColumn;
    private final String timestampColumn;
    private final String eventIdentifierColumn;
    private final String aggregateIdentifierColumn;
    private final String sequenceNumberColumn;
    private final String typeColumn;
    private final String payloadTypeColumn;
    private final String payloadRevisionColumn;
    private final String payloadColumn;
    private final String metaDataColumn;

    public EventSchema() {
        this(EventSchema.builder());
    }

    private EventSchema(Builder builder) {
        this.domainEventTable = builder.domainEventTable;
        this.snapshotTable = builder.snapshotTable;
        this.globalIndexColumn = builder.globalIndexColumn;
        this.timestampColumn = builder.timestampColumn;
        this.eventIdentifierColumn = builder.eventIdentifierColumn;
        this.aggregateIdentifierColumn = builder.aggregateIdentifierColumn;
        this.sequenceNumberColumn = builder.sequenceNumberColumn;
        this.typeColumn = builder.typeColumn;
        this.payloadTypeColumn = builder.payloadTypeColumn;
        this.payloadRevisionColumn = builder.payloadRevisionColumn;
        this.payloadColumn = builder.payloadColumn;
        this.metaDataColumn = builder.metaDataColumn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String domainEventTable() {
        return this.domainEventTable;
    }

    public String snapshotTable() {
        return this.snapshotTable;
    }

    public String globalIndexColumn() {
        return this.globalIndexColumn;
    }

    public String timestampColumn() {
        return this.timestampColumn;
    }

    public String eventIdentifierColumn() {
        return this.eventIdentifierColumn;
    }

    public String aggregateIdentifierColumn() {
        return this.aggregateIdentifierColumn;
    }

    public String sequenceNumberColumn() {
        return this.sequenceNumberColumn;
    }

    public String typeColumn() {
        return this.typeColumn;
    }

    public String payloadTypeColumn() {
        return this.payloadTypeColumn;
    }

    public String payloadRevisionColumn() {
        return this.payloadRevisionColumn;
    }

    public String payloadColumn() {
        return this.payloadColumn;
    }

    public String metaDataColumn() {
        return this.metaDataColumn;
    }

    public static class Builder {
        private String domainEventTable = "DomainEventEntry";
        private String snapshotTable = "SnapshotEventEntry";
        private String globalIndexColumn = "globalIndex";
        private String timestampColumn = "timeStamp";
        private String eventIdentifierColumn = "eventIdentifier";
        private String aggregateIdentifierColumn = "aggregateIdentifier";
        private String sequenceNumberColumn = "sequenceNumber";
        private String typeColumn = "type";
        private String payloadTypeColumn = "payloadType";
        private String payloadRevisionColumn = "payloadRevision";
        private String payloadColumn = "payload";
        private String metaDataColumn = "metaData";

        public Builder withEventTable(String eventTable) {
            this.domainEventTable = eventTable;
            return this;
        }

        public Builder withSnapshotTable(String snapshotTable) {
            this.snapshotTable = snapshotTable;
            return this;
        }

        public Builder withGlobalIndexColumn(String globalIndexColumn) {
            this.globalIndexColumn = globalIndexColumn;
            return this;
        }

        public Builder withTimestampColumn(String timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public Builder withEventIdentifierColumn(String eventIdentifierColumn) {
            this.eventIdentifierColumn = eventIdentifierColumn;
            return this;
        }

        public Builder withAggregateIdentifierColumn(String aggregateIdentifierColumn) {
            this.aggregateIdentifierColumn = aggregateIdentifierColumn;
            return this;
        }

        public Builder withSequenceNumberColumn(String sequenceNumberColumn) {
            this.sequenceNumberColumn = sequenceNumberColumn;
            return this;
        }

        public Builder withTypeColumn(String typeColumn) {
            this.typeColumn = typeColumn;
            return this;
        }

        public Builder withPayloadTypeColumn(String payloadTypeColumn) {
            this.payloadTypeColumn = payloadTypeColumn;
            return this;
        }

        public Builder withPayloadRevisionColumn(String payloadRevisionColumn) {
            this.payloadRevisionColumn = payloadRevisionColumn;
            return this;
        }

        public Builder withPayloadColumn(String payloadColumn) {
            this.payloadColumn = payloadColumn;
            return this;
        }

        public Builder withMetaDataColumn(String metaDataColumn) {
            this.metaDataColumn = metaDataColumn;
            return this;
        }

        public EventSchema build() {
            return new EventSchema(this);
        }
    }
}

