/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Iterator;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;

public class IteratorBackedDomainEventStream
implements DomainEventStream {
    private final Iterator<? extends DomainEventMessage<?>> iterator;
    private boolean hasPeeked;
    private DomainEventMessage<?> peekEvent;
    private Long sequenceNumber;

    public IteratorBackedDomainEventStream(Iterator<? extends DomainEventMessage<?>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public DomainEventMessage<?> peek() {
        if (!this.hasPeeked) {
            this.peekEvent = this.readNext();
            this.hasPeeked = true;
        }
        return this.peekEvent;
    }

    @Override
    public boolean hasNext() {
        return this.hasPeeked || this.iterator.hasNext();
    }

    @Override
    public DomainEventMessage<?> next() {
        if (!this.hasPeeked) {
            return this.readNext();
        }
        DomainEventMessage<?> result = this.peekEvent;
        this.peekEvent = null;
        this.hasPeeked = false;
        return result;
    }

    private DomainEventMessage<?> readNext() {
        DomainEventMessage<?> next = this.iterator.next();
        this.sequenceNumber = next.getSequenceNumber();
        return next;
    }

    @Override
    public Long getLastSequenceNumber() {
        return this.sequenceNumber;
    }
}

