/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.eventsourcing.GenericTrackedDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventData;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.UnknownSerializedTypeException;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventUtils {
    private static final Logger logger = LoggerFactory.getLogger(EventUtils.class);

    public static <T> TrackedEventMessage<T> asTrackedEventMessage(EventMessage<T> eventMessage, TrackingToken trackingToken) {
        if (eventMessage instanceof DomainEventMessage) {
            return new GenericTrackedDomainEventMessage(trackingToken, (DomainEventMessage)eventMessage);
        }
        return new GenericTrackedEventMessage<T>(trackingToken, eventMessage);
    }

    public static <T> DomainEventMessage<T> asDomainEventMessage(EventMessage<T> eventMessage) {
        if (eventMessage instanceof DomainEventMessage) {
            return (DomainEventMessage)eventMessage;
        }
        return new GenericDomainEventMessage<T>(null, eventMessage.getIdentifier(), 0L, eventMessage, eventMessage::getTimestamp);
    }

    public static DomainEventStream upcastAndDeserializeDomainEvents(Stream<? extends DomainEventData<?>> eventEntryStream, Serializer serializer, EventUpcaster upcasterChain, boolean skipUnknownTypes) {
        AtomicReference currentSequenceNumber = new AtomicReference();
        Stream<IntermediateEventRepresentation> upcastResult = EventUtils.upcastAndDeserialize(eventEntryStream, serializer, upcasterChain, skipUnknownTypes, entry -> {
            InitialEventRepresentation result = new InitialEventRepresentation((EventData<?>)entry, serializer);
            currentSequenceNumber.set(result.getSequenceNumber().get());
            return result;
        });
        Stream<GenericDomainEventMessage> stream = upcastResult.map(ir -> {
            SerializedMessage serializedMessage = new SerializedMessage(ir.getMessageIdentifier(), new LazyDeserializingObject(ir::getData, ir.getType(), serializer), ir.getMetaData());
            if (ir.getTrackingToken().isPresent()) {
                return new GenericTrackedDomainEventMessage(ir.getTrackingToken().get(), ir.getAggregateType().get(), ir.getAggregateIdentifier().get(), (long)ir.getSequenceNumber().get(), serializedMessage, ir::getTimestamp);
            }
            return new GenericDomainEventMessage(ir.getAggregateType().get(), ir.getAggregateIdentifier().get(), (long)ir.getSequenceNumber().get(), serializedMessage, ir::getTimestamp);
        });
        return DomainEventStream.of(stream, currentSequenceNumber::get);
    }

    public static Stream<TrackedEventMessage<?>> upcastAndDeserializeTrackedEvents(Stream<? extends TrackedEventData<?>> eventEntryStream, Serializer serializer, EventUpcaster upcasterChain, boolean skipUnknownTypes) {
        Stream<IntermediateEventRepresentation> upcastResult = EventUtils.upcastAndDeserialize(eventEntryStream, serializer, upcasterChain, skipUnknownTypes, entry -> new InitialEventRepresentation((EventData<?>)entry, serializer));
        return upcastResult.map(ir -> {
            SerializedMessage serializedMessage = new SerializedMessage(ir.getMessageIdentifier(), new LazyDeserializingObject(ir::getData, ir.getType(), serializer), ir.getMetaData());
            if (ir.getAggregateIdentifier().isPresent()) {
                return new GenericTrackedDomainEventMessage(ir.getTrackingToken().get(), (String)ir.getAggregateType().orElse(null), ir.getAggregateIdentifier().get(), (long)ir.getSequenceNumber().get(), serializedMessage, ir::getTimestamp);
            }
            return new GenericTrackedEventMessage(ir.getTrackingToken().get(), serializedMessage, ir::getTimestamp);
        });
    }

    public static Stream<? extends DomainEventMessage<?>> asStream(DomainEventStream domainEventStream) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(domainEventStream, 273), false);
    }

    private static Stream<IntermediateEventRepresentation> upcastAndDeserialize(Stream<? extends EventData<?>> eventEntryStream, Serializer serializer, EventUpcaster upcasterChain, boolean skipUnknownTypes, Function<EventData<?>, IntermediateEventRepresentation> entryConverter) {
        Stream<IntermediateEventRepresentation> upcastResult = upcasterChain.upcast(eventEntryStream.map(entryConverter));
        if (skipUnknownTypes) {
            upcastResult = upcastResult.filter(ir -> {
                try {
                    serializer.classForType(ir.getType());
                    return true;
                }
                catch (UnknownSerializedTypeException e) {
                    return false;
                }
            });
        }
        return upcastResult;
    }

    private EventUtils() {
    }
}

