/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Optional;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;

public interface EventStore
extends EventBus {
    public DomainEventStream readEvents(String var1);

    default public DomainEventStream readEvents(String aggregateIdentifier, long firstSequenceNumber) {
        DomainEventStream wholeStream = this.readEvents(aggregateIdentifier);
        return DomainEventStream.of(wholeStream.asStream().filter(event -> event.getSequenceNumber() >= firstSequenceNumber), wholeStream::getLastSequenceNumber);
    }

    public void storeSnapshot(DomainEventMessage<?> var1);

    default public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        return this.readEvents(aggregateIdentifier).asStream().map(DomainEventMessage::getSequenceNumber).max(Long::compareTo);
    }
}

