/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.io.IOUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.eventstore.AbstractEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.TrackingEventStream;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedEventStore
extends AbstractEventStore {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedEventStore.class);
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup(EmbeddedEventStore.class.getSimpleName());
    private final Lock consumerLock = new ReentrantLock();
    private final Condition consumableEventsCondition = this.consumerLock.newCondition();
    private final Set<EventConsumer> tailingConsumers = new CopyOnWriteArraySet<EventConsumer>();
    private final EventProducer producer;
    private final long cleanupDelayMillis;
    private final ThreadFactory threadFactory;
    private final ScheduledExecutorService cleanupService;
    private final AtomicBoolean producerStarted = new AtomicBoolean();
    private volatile Node oldest;

    public EmbeddedEventStore(EventStorageEngine storageEngine) {
        this(storageEngine, NoOpMessageMonitor.INSTANCE);
    }

    public EmbeddedEventStore(EventStorageEngine storageEngine, MessageMonitor<? super EventMessage<?>> monitor) {
        this(storageEngine, monitor, 10000, 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public EmbeddedEventStore(EventStorageEngine storageEngine, MessageMonitor<? super EventMessage<?>> monitor, int cachedEvents, long fetchDelay, long cleanupDelay, TimeUnit timeUnit) {
        this(storageEngine, monitor, 10000, 1000L, 10000L, TimeUnit.MILLISECONDS, new AxonThreadFactory(THREAD_GROUP));
    }

    public EmbeddedEventStore(EventStorageEngine storageEngine, MessageMonitor<? super EventMessage<?>> monitor, int cachedEvents, long fetchDelay, long cleanupDelay, TimeUnit timeUnit, ThreadFactory threadFactory) {
        super(storageEngine, monitor);
        this.threadFactory = threadFactory;
        this.cleanupService = Executors.newScheduledThreadPool(1, this.threadFactory);
        this.producer = new EventProducer(timeUnit.toNanos(fetchDelay), cachedEvents);
        this.cleanupDelayMillis = timeUnit.toMillis(cleanupDelay);
    }

    @PreDestroy
    public void shutDown() {
        this.tailingConsumers.forEach(IOUtils::closeQuietly);
        IOUtils.closeQuietly(this.producer);
        this.cleanupService.shutdownNow();
    }

    private void ensureProducerStarted() {
        if (this.producerStarted.compareAndSet(false, true)) {
            this.threadFactory.newThread(() -> {
                try {
                    this.producer.run();
                }
                catch (InterruptedException e) {
                    logger.warn("Producer thread was interrupted. Shutting down event store.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }).start();
            this.cleanupService.scheduleWithFixedDelay(new Cleaner(), this.cleanupDelayMillis, this.cleanupDelayMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void afterCommit(List<? extends EventMessage<?>> events) {
        this.producer.fetchIfWaiting();
    }

    @Override
    public TrackingEventStream openStream(TrackingToken trackingToken) {
        EventConsumer eventConsumer;
        Node node = this.findNode(trackingToken);
        if (node != null) {
            eventConsumer = new EventConsumer(node);
            this.tailingConsumers.add(eventConsumer);
        } else {
            eventConsumer = new EventConsumer(trackingToken);
        }
        return eventConsumer;
    }

    private Node findNode(TrackingToken trackingToken) {
        Node node = this.oldest;
        while (node != null && !node.event.trackingToken().equals(trackingToken)) {
            node = node.next;
        }
        return node;
    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            Node oldestCachedNode = EmbeddedEventStore.this.oldest;
            if (oldestCachedNode == null || oldestCachedNode.previousToken == null) {
                return;
            }
            EmbeddedEventStore.this.tailingConsumers.stream().filter(rec$ -> ((EventConsumer)rec$).behindGlobalCache()).forEach(consumer -> {
                logger.warn("An event processor fell behind the tail end of the event store cache. This usually indicates a badly performing event processor.");
                ((EventConsumer)consumer).stopTailingGlobalStream();
            });
        }
    }

    private class EventConsumer
    implements TrackingEventStream {
        private Stream<? extends TrackedEventMessage<?>> privateStream;
        private Iterator<? extends TrackedEventMessage<?>> privateIterator;
        private volatile TrackingToken lastToken;
        private volatile Node lastNode;
        private TrackedEventMessage<?> peekedEvent;

        private EventConsumer(Node lastNode) {
            this(lastNode.event.trackingToken());
            this.lastNode = lastNode;
        }

        private EventConsumer(TrackingToken startToken) {
            this.lastToken = startToken;
        }

        @Override
        public Optional<TrackedEventMessage<?>> peek() {
            return Optional.ofNullable(this.peekedEvent == null && !this.hasNextAvailable() ? null : this.peekedEvent);
        }

        @Override
        public boolean hasNextAvailable(int timeout, TimeUnit unit) throws InterruptedException {
            return this.peekedEvent != null || (this.peekedEvent = this.peek(timeout, unit)) != null;
        }

        @Override
        public TrackedEventMessage<?> nextAvailable() throws InterruptedException {
            while (this.peekedEvent == null) {
                this.peekedEvent = this.peek(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            TrackedEventMessage<?> result = this.peekedEvent;
            this.peekedEvent = null;
            return result;
        }

        private TrackedEventMessage<?> peek(int timeout, TimeUnit timeUnit) throws InterruptedException {
            boolean allowSwitchToTailingConsumer = true;
            if (EmbeddedEventStore.this.tailingConsumers.contains(this)) {
                if (!this.behindGlobalCache()) {
                    return this.peekGlobalStream(timeout, timeUnit);
                }
                this.stopTailingGlobalStream();
                allowSwitchToTailingConsumer = false;
            }
            return this.peekPrivateStream(allowSwitchToTailingConsumer, timeout, timeUnit);
        }

        private boolean behindGlobalCache() {
            return EmbeddedEventStore.this.oldest != null && (this.lastNode != null ? this.lastNode.index < EmbeddedEventStore.this.oldest.index : this.nextNode() == null);
        }

        private void stopTailingGlobalStream() {
            EmbeddedEventStore.this.tailingConsumers.remove(this);
            this.lastNode = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TrackedEventMessage<?> peekGlobalStream(int timeout, TimeUnit timeUnit) throws InterruptedException {
            Node nextNode = this.nextNode();
            if (nextNode == null && timeout > 0) {
                EmbeddedEventStore.this.consumerLock.lock();
                try {
                    EmbeddedEventStore.this.consumableEventsCondition.await(timeout, timeUnit);
                    nextNode = this.nextNode();
                }
                finally {
                    EmbeddedEventStore.this.consumerLock.unlock();
                }
            }
            if (nextNode != null) {
                if (EmbeddedEventStore.this.tailingConsumers.contains(this)) {
                    this.lastNode = nextNode;
                }
                this.lastToken = nextNode.event.trackingToken();
                return nextNode.event;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TrackedEventMessage<?> peekPrivateStream(boolean allowSwitchToTailingConsumer, int timeout, TimeUnit timeUnit) throws InterruptedException {
            if (this.privateIterator == null) {
                this.privateStream = EmbeddedEventStore.this.storageEngine().readEvents(this.lastToken, false);
                this.privateIterator = this.privateStream.iterator();
            }
            if (this.privateIterator.hasNext()) {
                TrackedEventMessage<?> nextEvent = this.privateIterator.next();
                this.lastToken = nextEvent.trackingToken();
                return nextEvent;
            }
            if (allowSwitchToTailingConsumer) {
                this.closePrivateStream();
                this.lastNode = EmbeddedEventStore.this.findNode(this.lastToken);
                EmbeddedEventStore.this.tailingConsumers.add(this);
                EmbeddedEventStore.this.ensureProducerStarted();
                return timeout > 0 ? this.peek(timeout, timeUnit) : null;
            }
            EmbeddedEventStore.this.consumerLock.lock();
            try {
                if (EmbeddedEventStore.this.consumableEventsCondition.await(timeout, timeUnit) && this.privateIterator.hasNext()) {
                    TrackedEventMessage<?> nextEvent = this.privateIterator.next();
                    this.lastToken = nextEvent.trackingToken();
                    TrackedEventMessage<?> trackedEventMessage = nextEvent;
                    return trackedEventMessage;
                }
                TrackedEventMessage<?> trackedEventMessage = null;
                return trackedEventMessage;
            }
            finally {
                EmbeddedEventStore.this.consumerLock.unlock();
            }
        }

        private Node nextNode() {
            Node node = this.lastNode;
            if (node != null) {
                return node.next;
            }
            node = EmbeddedEventStore.this.oldest;
            while (node != null && !Objects.equals(node.previousToken, this.lastToken)) {
                node = node.next;
            }
            return node;
        }

        private TrackingToken lastToken() {
            return this.lastToken;
        }

        @Override
        public void close() {
            this.closePrivateStream();
            this.stopTailingGlobalStream();
        }

        private void closePrivateStream() {
            Optional.ofNullable(this.privateStream).ifPresent(stream -> {
                this.privateStream = null;
                this.privateIterator = null;
                stream.close();
            });
        }
    }

    private class EventProducer
    implements AutoCloseable {
        private final Lock lock = new ReentrantLock();
        private final Condition dataAvailableCondition = this.lock.newCondition();
        private final long fetchDelayNanos;
        private final int cachedEvents;
        private volatile boolean shouldFetch;
        private volatile boolean closed;
        private Stream<? extends TrackedEventMessage<?>> eventStream;
        private Node newest;

        private EventProducer(long fetchDelayNanos, int cachedEvents) {
            this.fetchDelayNanos = fetchDelayNanos;
            this.cachedEvents = cachedEvents;
        }

        private void run() throws InterruptedException {
            boolean dataFound = false;
            while (!this.closed) {
                this.shouldFetch = true;
                while (this.shouldFetch) {
                    this.shouldFetch = false;
                    dataFound = this.fetchData();
                }
                if (dataFound) continue;
                this.waitForData();
            }
        }

        private void waitForData() throws InterruptedException {
            this.lock.lock();
            try {
                if (!this.shouldFetch) {
                    this.dataAvailableCondition.awaitNanos(this.fetchDelayNanos);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void fetchIfWaiting() {
            this.shouldFetch = true;
            this.lock.lock();
            try {
                this.dataAvailableCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean fetchData() {
            Node currentNewest = this.newest;
            if (!EmbeddedEventStore.this.tailingConsumers.isEmpty()) {
                try {
                    this.eventStream = EmbeddedEventStore.this.storageEngine().readEvents(this.lastToken(), true);
                    this.eventStream.forEach(event -> {
                        Node node = new Node(this.nextIndex(), this.lastToken(), (TrackedEventMessage)event);
                        if (this.newest != null) {
                            this.newest.next = node;
                        }
                        this.newest = node;
                        if (EmbeddedEventStore.this.oldest == null) {
                            EmbeddedEventStore.this.oldest = node;
                        }
                        this.notifyConsumers();
                        this.trimCache();
                    });
                }
                catch (Exception e) {
                    logger.error("Failed to read events from the underlying event storage", (Throwable)e);
                }
            }
            return !Objects.equals(this.newest, currentNewest);
        }

        private TrackingToken lastToken() {
            if (this.newest == null) {
                List tokens = EmbeddedEventStore.this.tailingConsumers.stream().map(rec$ -> ((EventConsumer)rec$).lastToken()).collect(Collectors.toList());
                return tokens.isEmpty() || tokens.contains(null) ? null : (TrackingToken)tokens.get(0);
            }
            return this.newest.event.trackingToken();
        }

        private long nextIndex() {
            return this.newest == null ? 0L : this.newest.index + 1L;
        }

        private void notifyConsumers() {
            EmbeddedEventStore.this.consumerLock.lock();
            try {
                EmbeddedEventStore.this.consumableEventsCondition.signalAll();
            }
            finally {
                EmbeddedEventStore.this.consumerLock.unlock();
            }
        }

        private void trimCache() {
            Node last = EmbeddedEventStore.this.oldest;
            while (this.newest != null && last != null && this.newest.index - last.index >= (long)this.cachedEvents) {
                last = last.next;
            }
            EmbeddedEventStore.this.oldest = last;
        }

        @Override
        public void close() {
            this.closed = true;
            if (this.eventStream != null) {
                this.eventStream.close();
            }
        }
    }

    private static class Node {
        private final long index;
        private final TrackingToken previousToken;
        private final TrackedEventMessage<?> event;
        private volatile Node next;

        private Node(long index, TrackingToken previousToken, TrackedEventMessage<?> event) {
            this.index = index;
            this.previousToken = previousToken;
            this.event = event;
        }
    }
}

