/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventsourcing.eventstore.AbstractEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;

public abstract class BatchingEventStorageEngine
extends AbstractEventStorageEngine {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private final int batchSize;

    public BatchingEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Integer batchSize) {
        this(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, null, batchSize);
    }

    public BatchingEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Predicate<? super DomainEventData<?>> snapshotFilter, Integer batchSize) {
        super(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, snapshotFilter);
        this.batchSize = ObjectUtils.getOrDefault(batchSize, 100);
    }

    protected abstract List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken var1, int var2);

    protected abstract List<? extends DomainEventData<?>> fetchDomainEvents(String var1, long var2, int var4);

    @Override
    protected Stream<? extends DomainEventData<?>> readEventData(String identifier, long firstSequenceNumber) {
        EventStreamSpliterator spliterator = new EventStreamSpliterator(lastItem -> this.fetchDomainEvents(identifier, lastItem == null ? firstSequenceNumber : lastItem.getSequenceNumber() + 1L, this.batchSize), this.batchSize, false);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    protected Stream<? extends TrackedEventData<?>> readEventData(TrackingToken trackingToken, boolean mayBlock) {
        EventStreamSpliterator spliterator = new EventStreamSpliterator(lastItem -> this.fetchTrackedEvents(lastItem == null ? trackingToken : lastItem.trackingToken(), this.batchSize), this.batchSize, true);
        return StreamSupport.stream(spliterator, false);
    }

    public int batchSize() {
        return this.batchSize;
    }

    private static class EventStreamSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Function<T, List<? extends T>> fetchFunction;
        private final int batchSize;
        private final boolean fetchUntilEmpty;
        private Iterator<? extends T> iterator;
        private T lastItem;
        private int sizeOfLastBatch;

        private EventStreamSpliterator(Function<T, List<? extends T>> fetchFunction, int batchSize, boolean fetchUntilEmpty) {
            super(Long.MAX_VALUE, 4369);
            this.fetchFunction = fetchFunction;
            this.batchSize = batchSize;
            this.fetchUntilEmpty = fetchUntilEmpty;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            if (this.iterator == null || !this.iterator.hasNext()) {
                if (this.iterator != null && this.batchSize > this.sizeOfLastBatch && !this.fetchUntilEmpty) {
                    return false;
                }
                List<T> items = this.fetchFunction.apply(this.lastItem);
                this.iterator = items.iterator();
                this.sizeOfLastBatch = items.size();
                if (this.sizeOfLastBatch == 0) {
                    return false;
                }
            }
            this.lastItem = this.iterator.next();
            action.accept(this.lastItem);
            return true;
        }
    }
}

